/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5GroupFooter;
import com.cognos.xqe.ast.v5.result.V5GroupHeader;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.rowInfo.ColumnInfo;
import com.cognos.xqe.util.rowInfo.RowInfo;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class CollectRSAPIInfoForREST
extends Transformation {
    private static final String ROW_INFO_IS_EMPTY = "rowInfo.isEmpty()";
    private static final String ROW_SET_IS_NULL = "rowSet == null";
    private static final String VS_IS_NULL = "vs == null";
    private static final String ERR_MSG = "dataItemOrdinal == RSAPIEdgeRowset.REF_DATA_ITEM_ORDINAL";

    public CollectRSAPIInfoForREST() {
        this.mName = "Collect RSAPI info for processing query service REST resultset.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 1;
        this.mTypes = new int[1];
        this.mTypes[0] = 401005;
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataset dataset = (RSAPIDataset)node;
        LinkedHashMap<Integer, List<RowInfo>> qsRowInfo = CollectRSAPIInfoForREST.collectRowInfo(dataset);
        dataset.setRESTRowInfo(qsRowInfo);
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        RSAPIDataset dataset = (RSAPIDataset)node;
        if (dataset.getParent() == null || dataset.getParent().getType() != 101002) {
            this.traceNodeCondition(false, "Parent is not a V5QuerySet.", trace);
            return false;
        }
        if (!((V5QuerySet)dataset.getParent()).isForREST()) {
            this.traceNodeCondition(false, "Is not for query-service.", trace);
            return false;
        }
        if (dataset.isInvalidReport()) {
            this.traceNodeCondition(false, "The report layout has not yet been validated.", trace);
            return false;
        }
        if (!dataset.getDataTypesAdjusted()) {
            this.traceNodeCondition(false, "No attempt has been made to adjust data item types.", trace);
            return false;
        }
        if (dataset.getRESTRowInfo() != null) {
            this.traceNodeCondition(false, "QS_RowInfo has been already collected.", trace);
            return false;
        }
        this.traceNodeCondition(true, "QS_RowInfo needs to be collected.", trace);
        return true;
    }

    private static LinkedHashMap<Integer, List<RowInfo>> collectRowInfo(RSAPIDataset dataset) {
        IXQEQueryNode[] edges;
        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)dataset.getFirstChildByType(101055);
        if (v5QRD == null) {
            throw new IllegalStateException("v5QRD == null");
        }
        V5Query v5Query = v5QRD.getV5Query();
        if (v5Query == null) {
            throw new IllegalStateException("v5Query == null");
        }
        boolean isRelStyle = v5Query.isRelStyle();
        int rowId = 0;
        LinkedHashMap<Integer, List<RowInfo>> allRowInfo = new LinkedHashMap<Integer, List<RowInfo>>();
        for (IXQEQueryNode edge : edges = v5QRD.getDescendantsOfType(101049, false)) {
            IXQEQueryNode ancestorGroup;
            ArrayList<RowInfo> rowInfoList = new ArrayList<RowInfo>();
            List<IXQEQueryNode> edgeGroups = edge.getDescendantsOfTypeOrdered(101050, false);
            for (IXQEQueryNode edgeGroup : edgeGroups) {
                if (edgeGroup.getChildrenOfType(101050).length > 0) continue;
                RowInfo rowInfo = new RowInfo(rowId++);
                CollectRSAPIInfoForREST.createRowColumnForEdgeGroup(edgeGroup, rowInfo, isRelStyle);
                for (ancestorGroup = edgeGroup.getAncestorOfType(101050); ancestorGroup != null; ancestorGroup = ancestorGroup.getAncestorOfType(101050)) {
                    CollectRSAPIInfoForREST.createRowColumnForEdgeGroup(ancestorGroup, rowInfo, isRelStyle);
                }
                rowInfoList.add(rowInfo);
                if (!dataset.isListReport()) continue;
                CollectRSAPIInfoForREST.createRowColumnForListSummary(edgeGroup, rowInfoList, isRelStyle, 101053);
                CollectRSAPIInfoForREST.createRowColumnForListSummary(edgeGroup, rowInfoList, isRelStyle, 101052);
            }
            ArrayList<Integer> processedGroups = new ArrayList<Integer>();
            if (dataset.isListReport()) {
                for (IXQEQueryNode edgeGroup : edgeGroups) {
                    if (edgeGroup.getChildrenOfType(101050).length > 0) continue;
                    for (ancestorGroup = edgeGroup.getAncestorOfType(101050); ancestorGroup != null; ancestorGroup = ancestorGroup.getAncestorOfType(101050)) {
                        if (processedGroups.contains(ancestorGroup.getId())) continue;
                        CollectRSAPIInfoForREST.createRowColumnForListSummary(ancestorGroup, rowInfoList, isRelStyle, 101053);
                        CollectRSAPIInfoForREST.createRowColumnForListSummary(ancestorGroup, rowInfoList, isRelStyle, 101052);
                        processedGroups.add(ancestorGroup.getId());
                    }
                }
            }
            allRowInfo.put(((V5Edge)edge).getEdgeID(), rowInfoList);
        }
        return allRowInfo;
    }

    private static void createRowColumnForEdgeGroup(IXQEQueryNode edgeGroup, RowInfo rowInfo, boolean isRelStyle) {
        V5ValueSet vs = (V5ValueSet)edgeGroup.getFirstChildByType(101057);
        if (vs == null) {
            throw new IllegalStateException(VS_IS_NULL);
        }
        RSAPIEdgeRowset rowSet = vs.getRSAPIEdgeRowset();
        if (rowSet == null) {
            throw new IllegalStateException(ROW_SET_IS_NULL);
        }
        IXQEQueryNode groupBody = vs.getFirstChildByType(101051);
        if (rowSet.getRefDataItem() != null) {
            IMetadata modelRef;
            RSAPIDataItem rsapiDataItem = rowSet.getRefDataItem();
            ColumnInfo rc = new ColumnInfo(rowSet.getRowsetId(), -1, rsapiDataItem.getName(), rowSet.getName());
            if (rowSet.isHeaderRowset()) {
                rc.setHeader(true);
            }
            if (rowSet.isFooterRowset()) {
                rc.setFooter(true);
            }
            if (vs.getPlanningEnvironment() != null && rsapiDataItem.getModelReference() != null && vs.getPlanningEnvironment().getMetadataConnection() != null && vs.getPlanningEnvironment().getMetadataConnection() instanceof MoserMetadataConnection && !(rsapiDataItem.getModelReference() instanceof MoserMetadataConnection) && (modelRef = rsapiDataItem.getModelReference()).getConnection() != null) {
                MoserMetadataConnection mmConnection = (MoserMetadataConnection)vs.getPlanningEnvironment().getMetadataConnection();
                String alias = mmConnection.getAliasMFWMetadataConnection(modelRef.getConnection());
                rc.setMoserAlias(alias);
            }
            rowInfo.addFirstColumnInfo(rc);
            if (null != groupBody) {
                for (IXQEQueryNode child : groupBody.getChildren()) {
                    if (child.getType() != 101015) continue;
                    V5DataItemRef dataItemRef = (V5DataItemRef)child;
                    String dataItemId = dataItemRef.getDataItemRefProperty();
                    int dataItemOrdinal = rowSet.getDataItemOrdinalByName(dataItemId);
                    RSAPIDataItem nonDetailDataItem = rowSet.getDataItem(dataItemOrdinal);
                    if (!isRelStyle && nonDetailDataItem.getUsage() == RSAPIUsage.FACT) continue;
                    if (dataItemOrdinal == -1) {
                        throw new IllegalStateException(ERR_MSG);
                    }
                    ColumnInfo nonDetailCol = new ColumnInfo(rowSet.getRowsetId(), dataItemOrdinal, dataItemId, rowSet.getName());
                    nonDetailCol.setNonDetail(true);
                    rowInfo.addColumnInfo(nonDetailCol, 0, dataItemOrdinal + 1);
                }
            }
            return;
        }
        if (groupBody == null) {
            throw new IllegalStateException("groupBody == null && rowSet.getRefDataItem() == null");
        }
        for (IXQEQueryNode child : groupBody.getChildren()) {
            if (child.getType() != 101015) continue;
            V5DataItemRef dataItemRef = (V5DataItemRef)child;
            String dataItemId = dataItemRef.getDataItemRefProperty();
            int dataItemOrdinal = rowSet.getDataItemOrdinalByName(dataItemId);
            if (dataItemOrdinal == -1) {
                throw new IllegalStateException(ERR_MSG);
            }
            ColumnInfo rc = new ColumnInfo(rowSet.getRowsetId(), dataItemOrdinal, dataItemId, rowSet.getName());
            rowInfo.addLastColumnInfo(rc);
        }
        if (rowInfo.isEmpty()) {
            throw new IllegalStateException(ROW_INFO_IS_EMPTY);
        }
    }

    private static boolean createRowColumnForListSummary(IXQEQueryNode edgeGroup, List<RowInfo> rowInfoList, boolean isRelStyle, int summaryType) {
        V5ValueSet vs = (V5ValueSet)edgeGroup.getFirstChildByType(101057);
        if (vs == null) {
            throw new IllegalStateException(VS_IS_NULL);
        }
        IXQEQueryNode summaryNode = vs.getFirstChildByType(summaryType);
        if (summaryNode == null) {
            return false;
        }
        RSAPIEdgeRowset rowSet = null;
        rowSet = summaryType == 101053 ? ((V5GroupHeader)summaryNode).getRSAPIEdgeRowset() : ((V5GroupFooter)summaryNode).getRSAPIEdgeRowset();
        if (rowSet == null) {
            throw new IllegalStateException(ROW_SET_IS_NULL);
        }
        RowInfo rowInfo = new RowInfo(rowInfoList.size());
        for (IXQEQueryNode child : summaryNode.getChildren()) {
            if (child.getType() != 101015) continue;
            V5DataItemRef dataItemRef = (V5DataItemRef)child;
            String dataItemId = dataItemRef.getDataItemRefProperty();
            int dataItemOrdinal = rowSet.getDataItemOrdinalByName(dataItemId);
            if (dataItemOrdinal == -1) {
                throw new IllegalStateException(ERR_MSG);
            }
            ColumnInfo rc = new ColumnInfo(rowSet.getRowsetId(), dataItemOrdinal, dataItemId, rowSet.getName());
            if (summaryNode instanceof V5GroupHeader) {
                rc.setHeader(true);
            } else {
                rc.setFooter(true);
            }
            rowInfo.addLastColumnInfo(rc);
        }
        if (rowInfo.isEmpty()) {
            throw new IllegalStateException(ROW_INFO_IS_EMPTY);
        }
        for (IXQEQueryNode ancestorGroup = edgeGroup.getAncestorOfType(101050); ancestorGroup != null; ancestorGroup = ancestorGroup.getAncestorOfType(101050)) {
            CollectRSAPIInfoForREST.createRowColumnForEdgeGroup(ancestorGroup, rowInfo, isRelStyle);
        }
        rowInfoList.add(rowInfo);
        return true;
    }
}

