/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class MoveLayoutSortItemToProperRowset
extends Transformation {
    public MoveLayoutSortItemToProperRowset() {
        this.mName = "Move the layout sort item from detail valueset to corresponding projected data item valueset.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 1;
        this.mTypes = new int[1];
        this.mTypes[0] = 101057;
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode v5Qrd = node.getAncestorOfType(101055);
        if (v5Qrd == null || !((V5QueryResultDefinition)v5Qrd).isList()) {
            this.traceNodeCondition(false, "The layout sort only applicable for list report.", trace);
            return false;
        }
        IXQEQueryNode[] sortItems = node.getChildrenOfType(101056);
        if (sortItems.length == 0) {
            this.traceNodeCondition(false, "The values set does not have a V5SortItem.", trace);
            return false;
        }
        V5Query query = ((V5QueryResultDefinition)v5Qrd).getV5Query();
        if (query.isDMR()) {
            for (IXQEQueryNode sortItem : sortItems) {
                String sortRefItem = ((V5SortItem)sortItem).getRefDataItem();
                V5ValueSet associatedValueSet = this.getAssociatedValuseSetForSortItem(node, sortRefItem);
                if (associatedValueSet == null) continue;
                this.traceNodeCondition(true, "The sort item is not in its associated value set.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "All sort items are projected in detail set only.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] sortItems;
        for (IXQEQueryNode sortItem : sortItems = node.getChildrenOfType(101056)) {
            String sortRefItem = ((V5SortItem)sortItem).getRefDataItem();
            V5ValueSet associatedValueSet = this.getAssociatedValuseSetForSortItem(node, sortRefItem);
            if (associatedValueSet == null) continue;
            IXQEQueryNode[] sortItemsInCurrentValueSet = associatedValueSet.getChildrenOfType(101056);
            boolean sortItemExistsInCurrentValueSet = false;
            for (IXQEQueryNode currentSortItem : sortItemsInCurrentValueSet) {
                String currentSortRefItem = ((V5SortItem)currentSortItem).getRefDataItem();
                if (!currentSortRefItem.equals(sortRefItem)) continue;
                sortItemExistsInCurrentValueSet = true;
                break;
            }
            if (!sortItemExistsInCurrentValueSet) {
                sortItem.move(associatedValueSet);
                continue;
            }
            sortItem.extract();
        }
    }

    private V5ValueSet getAssociatedValuseSetForSortItem(IXQEQueryNode node, String sortRefItem) {
        IXQEQueryNode[] valueSetsOnEdge;
        if (sortRefItem != null && sortRefItem.equals(((V5ValueSet)node).getRefDataItemProperty())) {
            return null;
        }
        IXQEQueryNode groupBody = node.getFirstChildByType(101051);
        if (groupBody != null) {
            IXQEQueryNode[] refDataItems;
            for (IXQEQueryNode refDataItem : refDataItems = groupBody.getChildrenOfType(101015)) {
                if (!sortRefItem.equals(((V5DataItemRef)refDataItem).getDataItemRefProperty())) continue;
                return null;
            }
        }
        IXQEQueryNode v5Edge = node.getAncestorOfType(101049);
        for (IXQEQueryNode currentValueSetOnEdge : valueSetsOnEdge = v5Edge.getDescendantsOfType(101057, false)) {
            String refDataItem = ((V5ValueSet)currentValueSetOnEdge).getRefDataItemProperty();
            if (refDataItem == null || refDataItem.equals("") || !refDataItem.equals(sortRefItem) || currentValueSetOnEdge == node) continue;
            return (V5ValueSet)currentValueSetOnEdge;
        }
        return null;
    }
}

