/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPICellRowset;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;

public class RecheckAddRSAPICellRowset
extends Transformation {
    private static final String STRING_VALUE = "value";

    public RecheckAddRSAPICellRowset() {
        this.mName = "Check if a cell rowset is required after query planning.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 1;
        this.mTypes = new int[1];
        this.mTypes[0] = 401005;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = false;
        XQETrace trace = environment.getTrace();
        RSAPIDataset dataset = (RSAPIDataset)node;
        if (dataset.getCellRowset() != null) {
            return false;
        }
        if (dataset.isCrossTabReport()) {
            boolean containsMeasureRowset = false;
            RSAPIEdge[] edges = dataset.getEdges();
            for (int i = 0; i < edges.length; ++i) {
                RSAPIEdgeRowset[] rowsets = edges[i].getRowsets();
                if (rowsets == null) continue;
                for (int j = 0; j < rowsets.length; ++j) {
                    if (!((RSAPIRowset)rowsets[j]).isMeasureRowset()) continue;
                    containsMeasureRowset = true;
                    break;
                }
                if (containsMeasureRowset) break;
            }
            if (containsMeasureRowset) {
                status = true;
                this.traceNodeCondition(status, "The QRD has multiple edges and a measure rowset.", trace);
            } else {
                status = false;
                this.traceNodeCondition(status, "The QRD has multiple edges but no measure rowset.", trace);
            }
        } else {
            status = false;
            this.traceNodeCondition(status, "The QRD does not represent a cross tab, so it has no cell rowset.", trace);
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPICellRowset cellRowset = new RSAPICellRowset();
        RSAPIDataset dataset = (RSAPIDataset)node;
        cellRowset.setRowsetId(0);
        RSAPIDataItem dataItem = new RSAPIDataItem();
        dataItem.setDataType(VariantType.VARIANT);
        dataItem.setUsage(RSAPIUsage.FACT);
        dataItem.setNullable(true);
        dataItem.setName(STRING_VALUE);
        dataItem.setLabel(STRING_VALUE);
        cellRowset.setDataItem(0, dataItem);
        dataset.setCellRowset(cellRowset);
        environment.setTreeHasBeenModified();
    }
}

