/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.trace.XQETrace;

public class RemoveRSAPICellRowset
extends Transformation {
    public RemoveRSAPICellRowset() {
        this.mName = "Remove RS API cell rowset of a RS API dataset.";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 1;
        this.mTypes = new int[1];
        this.mTypes[0] = 401005;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        RSAPIDataset dataset = (RSAPIDataset)node;
        if (dataset.isCrossTabReport() && dataset.getCellRowset() != null) {
            boolean containsMeasureRowset = false;
            RSAPIEdge[] edges = dataset.getEdges();
            for (int i = 0; i < edges.length; ++i) {
                RSAPIEdgeRowset[] rowsets = edges[i].getRowsets();
                if (rowsets == null) continue;
                for (int j = 0; j < rowsets.length; ++j) {
                    if (!((RSAPIRowset)rowsets[j]).isMeasureRowset()) continue;
                    containsMeasureRowset = true;
                    break;
                }
                if (containsMeasureRowset) break;
            }
            if (containsMeasureRowset) {
                status = false;
                this.traceNodeCondition(status, "The QRD has multiple edges and a measure rowset.", trace);
            } else {
                status = true;
                this.traceNodeCondition(status, "The QRD has multiple edges but no measure rowset.", trace);
            }
        } else {
            status = false;
            this.traceNodeCondition(status, "The QRD does not represent a cross tab, so it has no cell rowset.", trace);
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ((RSAPIDataset)node).setCellRowset(null);
        environment.setTreeHasBeenModified();
    }
}

