/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.rsapi;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ValidateQueryLayout
extends Transformation {
    public ValidateQueryLayout() {
        this.mName = "Determine the type of query (detail/group list or cross tab).";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 1;
        this.mTypes = new int[1];
        this.mTypes[0] = 401005;
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        RSAPIDataset dataset = (RSAPIDataset)node;
        boolean status = dataset.isInvalidReport();
        if (status) {
            this.traceNodeCondition(true, "The report layout has yet to be validated.", trace);
        } else {
            this.traceNodeCondition(false, "The report layout has already been validated.", trace);
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataset dataset = (RSAPIDataset)node;
        dataset.validateReportLayout();
        environment.setTreeHasBeenModified();
    }
}

