/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.XTabularResultSetSample;
import com.cognos.xqe.trace.XQETrace;

public final class GenerateXTabularResultSetSample
extends Transformation {
    public GenerateXTabularResultSetSample() {
        this.mName = "Generate XTabularResultSetSample node.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{401005};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        Integer sampleSeed;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        XTabularResultSetSample xNode = (XTabularResultSetSample)nodeFactory.createXNode(501208);
        Double samplePercent = (Double)querySet.getPropertyValue("samplePercent");
        Integer sampleRowCount = (Integer)querySet.getPropertyValue("sampleRowCount");
        if (samplePercent != null) {
            xNode.setSamplePercent(samplePercent);
            querySet.removeProperty("samplePercent");
        }
        if (sampleRowCount != null) {
            xNode.setSampleRowCount(sampleRowCount);
            querySet.removeProperty("sampleRowCount");
        }
        if ((sampleSeed = (Integer)querySet.getPropertyValue("sampleSeed")) != null) {
            xNode.setSampleSeed(sampleSeed.intValue());
            querySet.removeProperty("sampleSeed");
        }
        IXQEQueryNode xTreeFirstChild = node.getChild(0).getChild(0);
        xTreeFirstChild.insertParent(xNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataset dataset;
        boolean status;
        XQETrace trace = environment.getTrace();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        boolean bl = status = querySet != null;
        if (!status) {
            this.traceQueryCondition(status, "There is no V5QuerySet.", trace);
        }
        if (status && !(status = (dataset = (RSAPIDataset)node).isListReport())) {
            this.traceQueryCondition(status, "Not a list report.", trace);
        }
        if (status) {
            boolean bl2 = status = querySet.getPropertyValue("samplePercent") != null || querySet.getPropertyValue("sampleRowCount") != null;
            if (status) {
                this.traceQueryCondition(status, "Result set sampling options set for a list report.", trace);
            } else {
                this.traceQueryCondition(status, "No result set sampling options set.", trace);
            }
        }
        return status;
    }
}

