/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.maExp.MAConstraint;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.ActionCoordinateTypeEnum;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.ma.XMAAction;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;

public class GenerateXMAAction
extends Transformation {
    public GenerateXMAAction() {
        this.mName = "Genarate an executable actions node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1101018};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        this.traceQueryCondition(true, "An Action constraint node.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment planEnv) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)planEnv.getExecutionEnvironment();
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        String packageDataSourceName = planEnv.getMADataSource().getName();
        IDataSource dataSource = execEnv.getDataSourceByModelName(packageDataSourceName);
        Map<String, Object> dsProperties = dataSource.getMetadataProperties();
        String catalog = (String)dsProperties.get("catalog");
        String cube = (String)dsProperties.get("cube");
        MetadataRestriction restrictions = new MetadataRestriction();
        XMAAction xAction = (XMAAction)nodeFactory.createXNode(501121);
        IXQEQueryNode[] constraintNodes = node.getChildrenOfType(1101021);
        EnumSet<ActionCoordinateTypeEnum> coordinateTypes = EnumSet.noneOf(ActionCoordinateTypeEnum.class);
        ArrayList<String> coordinates = new ArrayList<String>();
        ArrayList<String> dimensionLine = new ArrayList<String>();
        ArrayList<String> properties = new ArrayList<String>();
        block0: for (IXQEQueryNode constraint : constraintNodes) {
            MAConstraint maConstraint = (MAConstraint)constraint;
            String constraintValue = maConstraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND);
            if (null == constraintValue) continue;
            if (maConstraint.getConstraint().equals("@coordinate")) {
                coordinates.add(GenerateXMAAction.getProviderMUN(planEnv, constraintValue));
                continue;
            }
            if (maConstraint.getConstraint().equals("@contextType")) {
                for (ActionCoordinateTypeEnum action : ActionCoordinateTypeEnum.values()) {
                    if (!action.toMDDSType().equals(constraintValue)) continue;
                    coordinateTypes.add(action);
                    continue block0;
                }
                continue;
            }
            if (maConstraint.getConstraint().equals("@dimensionLine")) {
                dimensionLine.add(GenerateXMAAction.getProviderMUN(planEnv, constraintValue));
                continue;
            }
            if (maConstraint.getConstraint().equals("@property")) {
                properties.add(constraintValue);
                continue;
            }
            if (maConstraint.getConstraint().equals("@from")) {
                restrictions.add(RestrictionType.FROM, constraintValue);
                continue;
            }
            if (!maConstraint.getConstraint().equals("@size")) continue;
            restrictions.add(RestrictionType.SIZE, constraintValue);
        }
        restrictions.add(RestrictionType.CATALOG, catalog);
        restrictions.add(RestrictionType.CUBE, cube);
        restrictions.add(RestrictionType.COORDINATE_TYPE, coordinateTypes);
        if (!coordinates.isEmpty()) {
            restrictions.add(RestrictionType.COORDINATE, coordinates);
        }
        if (!dimensionLine.isEmpty()) {
            restrictions.add(RestrictionType.DIMENSION_LINE, dimensionLine);
        }
        if (!properties.isEmpty()) {
            restrictions.add(RestrictionType.PROPERTY, properties);
        }
        xAction.setDataSource(dataSource);
        xAction.setCatalog(catalog);
        xAction.setRestrictions(restrictions);
        node.exchange(xAction);
    }

    private static String getProviderMUN(PlanningEnvironment planEnv, String cognosMUN) {
        MAMetadataItem mdi = new MAMetadataItem();
        mdi.bindMUNInModel(planEnv, cognosMUN);
        return mdi.getMemberUniqueName();
    }
}

