/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.ma.XMACollection;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashSet;
import java.util.Set;

public class GenerateXMACollection
extends Transformation {
    public GenerateXMACollection() {
        this.mName = "Genarate an executable collection node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1101019};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        int parentType = node.getParent().getType();
        boolean bl = status = parentType == 501109 || parentType == 501118 || parentType == 501110;
        if (status) {
            this.traceQueryCondition(status, "The parent is an executable MA node.", trace);
        } else {
            this.traceQueryCondition(status, "The parent is not an executable MA node.", trace);
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MACollection collection = (MACollection)node;
        XMACollection xCollection = (XMACollection)nodeFactory.createXNode(501110);
        node.getParent().exchangeChildNode(node, xCollection, true);
        String collectionName = (String)node.getPropertyValue("name");
        xCollection.setName(collectionName);
        Set<String> requiredProperties = collection.getRequiredProperties();
        if (requiredProperties == null) {
            requiredProperties = new HashSet<String>();
        }
        xCollection.setRequiredProperties(requiredProperties);
    }
}

