/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MARequest;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.ma.XMARequest;
import com.cognos.xqe.trace.XQETrace;

public class GenerateXMARequest
extends Transformation {
    public GenerateXMARequest() {
        this.mName = "Genarate the root node of MA executable request.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1101013};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getNumberChildren() > 0 && node.getChild(0).getType() != 501108;
        if (status) {
            this.traceQueryCondition(status, "Executable MA request has not been generated.", trace);
        } else {
            this.traceQueryCondition(status, "Executable MA request has been generated.", trace);
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MARequest request = (MARequest)node;
        XMARequest xRequest = (XMARequest)nodeFactory.createXNode(501108);
        IXQEQueryNode[] children = node.getChildren();
        node.addChild(xRequest);
        for (IXQEQueryNode child : children) {
            child.move(xRequest);
        }
        MetadataConnection connection = request.getMetadataConnection();
        xRequest.setMetadataConnection(connection);
        xRequest.setModelPath(request.getModelPath());
    }
}

