/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.ma.XMAQuery;
import com.cognos.xqe.trace.XQETrace;

public class RemovePlanningNodesFromMARuntree
extends Transformation {
    public RemovePlanningNodesFromMARuntree() {
        this.mName = "Remove the planning nodes from MA metadata query node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{501109, 501118};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XMAQuery xMAQuery = (XMAQuery)node;
        boolean status = this.getQueryHintAndInternalProperties(xMAQuery).length != 0;
        XQETrace trace = environment.getTrace();
        if (status) {
            this.traceQueryCondition(status, "There is MAQueryHint and MAInternalProperties planning node need to be removed.", trace);
        } else {
            this.traceQueryCondition(status, "There is no MAQueryHint or MAInternalProperties node.", trace);
        }
        return status;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] queryHintsAndInternalProperties;
        XMAQuery xMAQuery = (XMAQuery)node;
        for (IXQEQueryNode child : queryHintsAndInternalProperties = this.getQueryHintAndInternalProperties(xMAQuery)) {
            if (child.getType() == 1101023) {
                xMAQuery.addQueryHintProperty((String)child.getPropertyValue("value"));
            } else {
                xMAQuery.addInternalProperty((String)child.getPropertyValue("value"));
            }
            node.detachChild(child);
        }
        environment.setTreeHasBeenModified();
    }

    private IXQEQueryNode[] getQueryHintAndInternalProperties(XMAQuery query) {
        int[] typeMAQueryHintInternalProperties = new int[]{1101023, 1101025};
        return query.getChildrenOfTypes(typeMAQueryHintInternalProperties);
    }
}

