/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.XDimensionalStoreReference;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQuery;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQueryFactory;
import com.cognos.xqe.runtree.olap.querytemplates.MissingMemberValidateQuery;
import com.cognos.xqe.trace.XQETrace;

public final class GenerateMissingMemberValidateSubQuery
extends Transformation {
    public GenerateMissingMemberValidateSubQuery() {
        this.mName = "Generate the missing member's subquery node that may be used for any OLAPMemberDecorationRules.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{501144};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String errMsg = "xNodes.length == 0";
        XOLAPEdgeMapping xEdgeMappingNode = (XOLAPEdgeMapping)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ICube cube = xEdgeMappingNode.getCube();
        XMdx missingMemberQueryXMDX = null;
        missingMemberQueryXMDX = XOLAPEdgeMapping.isLolapQueryProviders(cube.getModelDataSource().getInterface()) ? (XMdx)nodeFactory.createXNode(501053) : (XMdx)nodeFactory.createXNode(501017);
        int[] types = new int[]{501017, 501053, 501095, 501158};
        IXQEQueryNode[] xNodes = xEdgeMappingNode.getDescendantsOfTypes(types, false);
        if (xNodes.length == 0) {
            xEdgeMappingNode.throwInternalError("xNodes.length == 0");
        }
        IXQEQueryNode xMdxNode = xNodes[0];
        int[] xmdxTypes = new int[]{501017, 501053};
        for (IXQEQueryNode eachNode : xNodes) {
            IXQEQueryNode aNode = eachNode;
            if (aNode.getType() == 501158) {
                IXQEQueryNode[] xmdxNodes = ((XDimensionalStoreReference)aNode).getReferencedDimStore().getDescendantsOfTypes(xmdxTypes, false);
                aNode = xmdxNodes[0];
            }
            if (aNode.getType() == 501017) {
                if (((XMdx)aNode).getMDXQuery() instanceof CustomQuery) continue;
                xMdxNode = aNode;
                break;
            }
            if (aNode.getType() != 501053 || ((XMdx)aNode).getMDXQuery() instanceof CustomQuery) continue;
            xMdxNode = aNode;
            break;
        }
        if (xMdxNode.getType() == 501017) {
            XMdx xMdx = (XMdx)xMdxNode;
            missingMemberQueryXMDX.setDataSource(xMdx.getDataSource());
            missingMemberQueryXMDX.setCatalog(xMdx.getCatalog());
            missingMemberQueryXMDX.setCube(cube.getName());
        } else if (xMdxNode.getType() == 501053) {
            XMdxLocal xMdxLocal = (XMdxLocal)xMdxNode;
            missingMemberQueryXMDX.setDataSource(xMdxLocal.getDataSource());
            missingMemberQueryXMDX.setCatalog(xMdxLocal.getCatalog());
            missingMemberQueryXMDX.setCube(cube.getName());
        }
        MissingMemberValidateQuery missingMemberQuery = (MissingMemberValidateQuery)CustomQueryFactory.createCustomQuery("MissingMemberValidateQuery", cube);
        String dataSourceType = xEdgeMappingNode.getDataSource().getInterface();
        if (DataSourceTypeEnum.isTM1(dataSourceType) || dataSourceType.equals("TMR")) {
            missingMemberQuery.setEscapeParameters(false);
        }
        missingMemberQueryXMDX.setMDXQuery(missingMemberQuery);
        xEdgeMappingNode.setMissingMemberQuery(missingMemberQueryXMDX);
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        String stringIS = "' is '";
        String stringTheValueOf = "The value of '";
        String stringPeriod = "'.";
        IDataSourceCapabilities capabilities = null;
        XMdx xMdxNode = (XMdx)node.getFirstDescendantOfCategory(501017, false);
        capabilities = xMdxNode != null ? xMdxNode.getMDXQuery().getCapabilities() : environment.getCapabilities(null);
        XOLAPEdgeMapping xNode = (XOLAPEdgeMapping)node;
        boolean missingMemberValidateQueryRequired = capabilities != null && capabilities.isSupported("queryProviderForMUNs") && xNode.isMissingMemberValidateQueryRequired();
        StringBuilder sb = new StringBuilder("The value of '");
        sb.append("missingMemberValidateQueryRequired");
        sb.append("' is '");
        sb.append(missingMemberValidateQueryRequired);
        sb.append("'.");
        this.traceNodeCondition(xNode.isMissingMemberValidateQueryRequired(), sb.toString(), trace);
        return missingMemberValidateQueryRequired;
    }
}

