/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.Map;

public final class GenerateXMdxNode
extends Transformation {
    private static XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryProcessing", LogLevel.INFO);

    public GenerateXMdxNode() {
        this.mName = "Generate The XMdx node, the runtree node executing a planned MDX query against a database.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (logger.isOn(LogLevel.INFO) && environment.getRoot().getType() == 101002) {
            mdxQuery.logQueryProcessingType(logger);
        }
        MDXFromCube fromCube = mdxQuery.getMDXFrom();
        IDataSource dataSource = fromCube.getCMDataSource();
        Map<String, Object> properties = dataSource.getMetadataProperties();
        XMdx xNode = (XMdx)nodeFactory.createXNode(501017);
        ArrayList<MDXDimensionProperties> aDimensionPropertiesList = new ArrayList<MDXDimensionProperties>();
        for (MDXEdge edge : mdxQuery.getEdges()) {
            aDimensionPropertiesList.add(edge.getDimensionProperties());
        }
        xNode.setDimPropertiesForAncestorQuery(aDimensionPropertiesList);
        xNode.setDataSource(dataSource);
        Object catalogName = properties.get("catalog");
        if (null != catalogName) {
            xNode.setCatalog((String)catalogName);
        } else {
            xNode.setCatalog("");
        }
        xNode.setCube(fromCube.getCube().getName());
        xNode.setMDXQuery(mdxQuery);
        xNode.setAxisCount(mdxQuery.getNumberOfEdges());
        xNode.setIsConstantQuery(mdxQuery.isConstantQuery());
        node.insertParent(xNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        int status = node.isValidPlannedQuery();
        if (status == -1) {
            this.traceNodeCondition(true, "The MDX query is valid.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The MDX query is not valid. Found issues in node " + status, trace);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        String nodeName = nodeFactory.getNodeTypeName(status);
        if (nodeName == null) {
            nodeName = ((IXQEQueryNode)nodeFactory.getNodeIndex().getNodeByID(new Integer(status))).getNodeTypeName();
        }
        if (nodeName == null) {
            nodeName = String.valueOf(status);
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_V5PlanFailed, nodeName);
    }
}

