/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.AbstractOLAPDecoration;
import com.cognos.xqe.ast.localprocessing.OLAPEdgeDecoration;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class Utility {
    private static final int[] VALID_OLAP_DECORATION_XNODES = new int[]{501027, 501026, 501085, 501144};
    private static final int[] VALID_NON_OLAP_DECORATION_XNODES = new int[]{501017, 501053, 501117, 501095, 501129, 501130, 501088};

    private Utility() {
    }

    private static boolean isOfTypes(IXQEQueryNode node, int[] types) {
        for (int type : types) {
            if (node.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidXNodeChild(IXQEQueryNode node) {
        if (Utility.isValidDecorationXNodeChild(node)) {
            return true;
        }
        return Utility.isOfTypes(node, VALID_NON_OLAP_DECORATION_XNODES);
    }

    public static boolean isValidDecorationXNodeChild(IXQEQueryNode node) {
        return Utility.isOfTypes(node, VALID_OLAP_DECORATION_XNODES);
    }

    static boolean nodeConditionForGroupedDecoFirstChild(Transformation transf, XQETrace trace, OLAPEdgeDecoration decoNode) {
        if (decoNode.getNumberChildren() > 0 && !decoNode.getIsGroupedDecoration()) {
            return Utility.nodeConditionForDecoFirstChild(transf, trace, decoNode);
        }
        transf.traceNodeCondition(false, "Target node is not grouped.", trace);
        return false;
    }

    static boolean nodeConditionForDecoFirstChild(Transformation transf, XQETrace trace, AbstractOLAPDecoration decoNode) {
        if (decoNode.getNumberChildren() > 0 && Utility.isValidXNodeChild(decoNode.getChild(0))) {
            transf.traceNodeCondition(true, "The child node is already a Xnode.", trace);
            return true;
        }
        transf.traceNodeCondition(false, "Need to wait the child node to be processed first.", trace);
        return false;
    }
}

