/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.relational.XTableFunction;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class CopyPlanningEnvForQueryReuseRuntrees
extends RQETransformation {
    public static final String CURSOR_EXECUTION_PLAN = "cursorExecutionPlan";

    public CopyPlanningEnvForQueryReuseRuntrees() {
        this.mName = "Remove planning references.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{501015};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XTableFunction function = (XTableFunction)node;
        XNode executionPlan = function.getSubTree();
        Object rEnv = environment.getRequestEnvironment();
        PlanningEnvironment newEnv = rEnv.getEnvFactory().createPlanningEnvironment();
        newEnv.setTrace(environment.getTrace());
        newEnv.setMetdataConnection(environment.getMetadataConnection());
        executionPlan.recursiveSetPlanningEnvironment(newEnv);
        function.setSubTree(null);
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XTableFunction function = (XTableFunction)node;
        boolean bl = status = function.getSubTree() != null;
        if (status) {
            this.traceQueryCondition(status, "Cursor execution plan needs to be copied from main planing environment.", trace);
        } else {
            this.traceQueryCondition(status, "Cursor execution plan does not need to be copied from main planing environment.", trace);
        }
        return status;
    }
}

