/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PersistentQueryPlan;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.runtree.relational.GenerateXLiteral;
import com.cognos.xqe.transformation.runtree.relational.GenerateXTableFunction;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IQueryReuseManager;
import com.cognos.xqe.util.QueryReuseEntry;
import com.cognos.xqeqte.QTEPlanningEnvironment;

public class GenerateCursorReference
extends RQETransformation {
    public GenerateCursorReference() {
        this.mName = "Replaces a cursor query block with cursor reference.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        GenerateCursorReference.doTransformation(node, environment);
    }

    static void doTransformation(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        XNode subtree = (XNode)qBlock.getChild(0);
        IXQEQueryNode[] nodes = subtree.getDescendantsOfType(501013, true);
        for (int i = 0; i < nodes.length; ++i) {
            ((XSql)nodes[i]).setCacheable(false);
        }
        subtree.detach();
        QueryReuseEntry qre = (QueryReuseEntry)qBlock.getReusableQuery();
        qre.addCursorInfo(qBlock, subtree);
        String collation = environment.getExecutionEnvironment().getLocalCollationSequenceKey().toString();
        IQueryReuseManager.CursorInfo cursorInfo = qre.getCursorInfo();
        if (cursorInfo == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Could not find cursor info for entry " + qre.getName() + ".");
        }
        cursorInfo.setCollation(collation);
        if (environment.getPlanningMode() == QTEPlanningEnvironment.PlanningMode.Compiling) {
            PersistentQueryPlan qp = environment.getQueryPlan();
            qp.addCursor(cursorInfo.getName(), new IXQEQueryNode[]{qBlock, subtree});
        }
        SQLTableFunction function = (SQLTableFunction)nodeFactory.createNode(301038);
        function.setSubType(SQLTableFunction.SubType.CURSOR);
        function.setDataType(SQLBinderUtil.makeRowTypeFromQueryItems(qBlock.getQueryItemList()));
        qBlock.exchange(function);
        function.setPropertyValue("cursorExecutionPlan", subtree);
        SQLLiteral literal = (SQLLiteral)nodeFactory.createNode(301031);
        literal.setDataType(DataTypeFactory.getObjectType());
        ObjectValue value = DataValueFactory.createObjectValue();
        value.set(cursorInfo);
        literal.setValue(value);
        function.addChild(literal);
        GenerateXLiteral.doTransformation(literal, environment);
        GenerateXTableFunction.doTransformation(function, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = ((SQLQueryBlock)node).getReusableQuery() != null;
        if (status) {
            this.traceQueryCondition(status, "Query block is a cursor reference.", trace);
        } else {
            this.traceQueryCondition(status, "Query block is not a cursor reference.", trace);
        }
        return status;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (RQPUtilities.getLocalCachePolicyFromGovernors(environment, node) == Governors.LocalCachePolicy.EXPLICITLY_PER_QUERY) {
            this.traceQueryCondition(false, "Local cache policy implies nesting cursors.", trace);
            return false;
        }
        return true;
    }
}

