/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.relational.XBurstCacheKeys;
import com.cognos.xqe.runtree.relational.XBurstPrefetch;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.List;

public class GenerateXBurstPrefetch
extends RQETransformation {
    private static final String AMBIGUOUS_DUE_TO_MULTIPLE_FILTER_NAMES = "Multiple detail filter parameters in XSQL node, unable to disambiguate.";

    public GenerateXBurstPrefetch() {
        this.mName = "Generate XBurstPrefetch node and XBurstCacheKeys node.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{501013};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        XBurstPrefetch prefetchNode = (XBurstPrefetch)factory.createXNode(501160);
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        node.insertParent(prefetchNode);
        String paramName = ((XSql)node).getDetailQueryFilterName().get(0);
        StringBuilder prefetchID = new StringBuilder(environment.getRequestEnvironment().getRequestID());
        RSAPIDataset detailRSAPI = (RSAPIDataset)node.getAncestorOfType(401005);
        prefetchID.append(detailRSAPI.getUniqueID());
        String prefetchIDstr = prefetchID.toString();
        prefetchNode.setParamName(paramName);
        prefetchNode.setPrefetchID(prefetchIDstr);
        String detailQName = detailRSAPI.getRefQueryName();
        MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
        List<String> mdLinkNames = mdProvider.getMasterDetailLinkNamesForParameter(paramName, detailQName);
        String refDataItem = mdProvider.getLink(mdLinkNames.get(0)).getMasterRefDataItem();
        String masterQName = (String)querySet.getPropertyValue(V5QuerySet.RequestHint.BURST_MASTER_QUERY_NAME.getPropertyName());
        XQEBaseQueryNode masterRSAPI = null;
        String plannedQName = null;
        for (IXQEQueryNode rsapiQuerySet : querySet.getChildren()) {
            if (rsapiQuerySet.getType() != 401005 || !(plannedQName = ((RSAPIDataset)rsapiQuerySet).getRefQueryName()).equals(masterQName)) continue;
            masterRSAPI = (RSAPIDataset)rsapiQuerySet;
            break;
        }
        XBurstCacheKeys xCacheKeysForMasterQ = (XBurstCacheKeys)factory.createXNode(501161);
        IXQEQueryNode masterXValueDecoNode = masterRSAPI.getFirstDescendantOfTypeOrdered(501043, false);
        masterXValueDecoNode.insertParent(xCacheKeysForMasterQ);
        for (RSAPIEdge edge : ((RSAPIDataset)masterRSAPI).getEdges()) {
            for (RSAPIEdgeRowset edgeRowset : edge.getRowsets()) {
                RSAPIDataItem[] dataItems = edgeRowset.getDataItems();
                RSAPIDataItem dataItem = null;
                for (RSAPIDataItem theDataItem : dataItems) {
                    if (!theDataItem.getName().equals(refDataItem)) continue;
                    dataItem = theDataItem;
                    break;
                }
                if (dataItem == null) {
                    dataItem = edgeRowset.getRefDataItem();
                }
                if (dataItem == null || !dataItem.getName().equals(refDataItem)) continue;
                int dataItemOrdinal = edgeRowset.getDataItemOrdinalByName(refDataItem);
                xCacheKeysForMasterQ.setProperites(edge.getOrdinal(), edgeRowset.getRowsetId(), dataItemOrdinal, prefetchIDstr);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
        if (!config.isBurstPrefetchEnabled()) {
            this.traceQueryCondition(false, "Burst prefetch disabled in configuration.", trace);
            return false;
        }
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (querySet == null) {
            this.traceQueryCondition(false, "The does not belong to a valid query set.", trace);
            return false;
        }
        String masterQName = (String)querySet.getPropertyValue(V5QuerySet.RequestHint.BURST_MASTER_QUERY_NAME.getPropertyName());
        if (!querySet.containsRequestHints() || masterQName == null) {
            this.traceQueryCondition(false, "No burst request hint specified.", trace);
            return false;
        }
        List<String> filterNames = ((XSql)node).getDetailQueryFilterName();
        if (filterNames.isEmpty()) {
            this.traceQueryCondition(false, "No detail filter parameters in XSQL node.", trace);
            return false;
        }
        if (filterNames.size() > 1) {
            this.traceQueryCondition(false, AMBIGUOUS_DUE_TO_MULTIPLE_FILTER_NAMES, trace);
            return false;
        }
        IXQEQueryNode[] allNativeBlocks = querySet.getDescendantsOfType(501013, false);
        if (allNativeBlocks.length > 1) {
            String filterName = filterNames.get(0);
            RSAPIDataset detailRSAPI = (RSAPIDataset)node.getAncestorOfType(401005);
            String string = detailRSAPI.getRefQueryName();
            MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
            if (mdProvider == null) {
                this.traceQueryCondition(false, "Could not find master-detail provider.", trace);
                return false;
            }
            List<String> mdLinkNames = mdProvider.getMasterDetailLinkNamesForParameter(filterName, string);
            if (mdLinkNames == null) {
                this.traceQueryCondition(false, "The parameter is not master-detail link parameter.", trace);
                return false;
            }
            if (!masterQName.equals(mdProvider.getLink(mdLinkNames.get(0)).getMasterQueryName())) {
                this.traceQueryCondition(false, "The parameter is not linked to master query: " + masterQName, trace);
                return false;
            }
        }
        XQEBaseQueryNode masterRSAPI = null;
        String plannedQName = null;
        for (IXQEQueryNode rsapiQuerySet : querySet.getChildren()) {
            if (rsapiQuerySet.getType() != 401005 || !(plannedQName = ((RSAPIDataset)rsapiQuerySet).getRefQueryName()).equals(masterQName)) continue;
            masterRSAPI = (RSAPIDataset)rsapiQuerySet;
            break;
        }
        if (masterRSAPI == null) {
            this.traceQueryCondition(false, "Couldn't find master RSAPI node with query name." + masterQName, trace);
            return false;
        }
        IXQEQueryNode iXQEQueryNode = masterRSAPI.getFirstDescendantOfTypeOrdered(501043, false);
        if (iXQEQueryNode == null) {
            this.traceQueryCondition(false, "Couldn't find required XValueDecoration node." + masterQName, trace);
            return false;
        }
        this.traceQueryCondition(true, "Add burst prefetch node above XSql node", trace);
        return true;
    }
}

