/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.dataset.XDataset;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ConnectionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class GenerateXDataset
extends RQETransformation {
    public GenerateXDataset() {
        this.mName = "Generate XDataset node.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        String name;
        String location;
        List<IXQEQueryNode> sqlFuncs = node.getDescendantsOfTypeOrdered(301033, false);
        if (!sqlFuncs.isEmpty()) {
            SQLFunction fnc = (SQLFunction)sqlFuncs.get(0);
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedFunction, fnc.getFunctionName());
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IDataSource dataSource = ((SQLQueryBlock)node).getDataSource();
        IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection(environment.getExecutionEnvironment(), dataSource);
        AbstractConnection connection = (AbstractConnection)pooledConnection.getConnection();
        File file = new File(connection.getUrl()).getAbsoluteFile();
        pooledConnection.returnConnection();
        String format = dataSource.getType().toLowerCase();
        if (file.isDirectory()) {
            SQLRelation relationNode = (SQLRelation)node.getDescendantsOfType(301016, false)[0];
            location = file.getPath();
            name = relationNode.getName().toLowerCase();
        } else {
            location = file.getParent();
            name = file.getName().split("\\.")[0];
        }
        ArrayList<SQLFid> fidList = new ArrayList<SQLFid>();
        IXQEQueryNode child = node.getChild(0);
        if (child.getType() == 301015) {
            fidList.addAll(CollectionCast.downcast(((SQLProject)child).getOutputList().getDescendantsOfTypeOrdered(301032, false), IXQEQueryNode.class, SQLFid.class));
            child = child.getChild(0);
        }
        int nProjectedColumns = fidList.size();
        List<SQLFid> additionalFids = CollectionCast.downcast(child.getDescendantsOfTypeOrdered(301032, false), IXQEQueryNode.class, SQLFid.class);
        for (SQLFid fid1 : additionalFids) {
            boolean found = false;
            for (SQLFid fid2 : fidList) {
                if (fid1.getColumnNo() != fid2.getColumnNo()) continue;
                found = true;
                break;
            }
            if (found) continue;
            fidList.add(fid1);
        }
        SQLExpression predicate = null;
        if (child.getType() == 301009) {
            predicate = ((SQLFilter)child).getPredicate();
        }
        int[] columns = new int[fidList.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = ((SQLFid)fidList.get(i)).getColumnNo();
        }
        XDataset xNode = (XDataset)nodeFactory.createXNode(501169);
        xNode.setDataSource(dataSource);
        xNode.setName(name);
        xNode.setLocation(location);
        xNode.setFormat(format);
        xNode.setNumberOfProjectedColumns(nProjectedColumns);
        xNode.setColumns(columns);
        xNode.setFilter(predicate);
        xNode.setVectorizationContext(new XVectorContext(nProjectedColumns));
        node.exchange(xNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IDataSource dataSource = ((SQLQueryBlock)node).getDataSource();
        if (!((SQLQueryBlock)node).isForeign()) {
            this.traceQueryCondition(false, "Node is not a foreign query block.", trace);
            return false;
        }
        SQLRelation relationNode = (SQLRelation)node.getDescendantsOfType(301016, false)[0];
        boolean bl = status = !relationNode.isWithClauseQueryRef() && dataSource != null && DataSourceTypeEnum.isColumnar(dataSource.getType());
        if (status) {
            this.traceNodeCondition(status, "Node is columnar dataset reference.", trace);
        } else {
            this.traceNodeCondition(status, "Node is not a columnar dataset reference.", trace);
        }
        return status;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        return true;
    }
}

