/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.parameters.ParameterInfo;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.relational.XHttpGet;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.FileHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class GenerateXHttpGet
extends Transformation {
    protected static final String HEADER = "\r\n\r\n\r\nNative SQL:\r\n";
    private static final String QUERY_EXECUTION_O_DATA_LAZY_LOADING_VALUE = "queryExecution.OData.lazyLoading[@value]";

    public GenerateXHttpGet() {
        this.mName = "Generate XHttpGet node.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{301004, 301038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLQueryBlock qBlock;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean lazyLoading = configuration.getBooleanProperty(QUERY_EXECUTION_O_DATA_LAZY_LOADING_VALUE, true);
        SQLTableFunction tableFuncNode = null;
        if (node.getType() == 301004) {
            qBlock = (SQLQueryBlock)node;
            tableFuncNode = (SQLTableFunction)node.getFirstDescendantOfTypeOrdered(301038, false);
            if (lazyLoading && tableFuncNode == null && qBlock.getOutputList() != null) {
                IXQEQueryNode[] fids = qBlock.getOutputList().getChildren();
                for (int i = 0; i < fids.length; ++i) {
                    SQLFid fid = (SQLFid)fids[i];
                    if (!DataTypeCode.isMultisetType(fid.getDataType().getCCLTypeCode()) || fid.getSourceNo() <= 0) continue;
                    fid.detach();
                }
            }
        } else {
            qBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
            tableFuncNode = (SQLTableFunction)node;
        }
        IDataSource dataSource = qBlock.getDataSource();
        XHttpGet xNode = (XHttpGet)nodeFactory.createXNode(501154);
        xNode.setDataSource(dataSource);
        xNode.setParamInfoListForSubstitution(this.generateParamInfoList(qBlock));
        RowsetInfo rowsetInfo = new RowsetInfo();
        IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection(environment.getExecutionEnvironment(), dataSource);
        AbstractConnection connection = (AbstractConnection)pooledConnection.getConnection();
        QueryFormatter builder = connection.getQueryBuilder(false);
        pooledConnection.returnConnection();
        qBlock.accept(builder, dataSource.getCapabilities());
        String query = builder.bufferToString();
        Object reqEnv = environment.getRequestEnvironment();
        if (this.isSQLFilePathSet((IRequestEnvironment)reqEnv)) {
            String path = reqEnv.getSqlFilePath();
            FileHandler.appendToFile(path, HEADER);
            FileHandler.appendToFile(path, "\r\n");
            FileHandler.appendToFile(path, query);
            FileHandler.appendToFile(path, "\r\n");
            FileHandler.appendToFile(path, "\r\n");
        }
        Object qNode = (SQLQueryNode)nodeFactory.createXNode(301031);
        ((SQLLiteral)qNode).setValue(DataValueFactory.createCharValue(query));
        if (tableFuncNode != null) {
            IXQEQueryNode parameterNode = tableFuncNode.getChild(1).detach();
            SQLValueExpression concatNode = (SQLValueExpression)nodeFactory.createNode(301025);
            concatNode.setSubType(SQLValueExpression.SubType.CONCATENATE);
            concatNode.addChild(parameterNode);
            concatNode.addChild((IXQEQueryNode)qNode);
            qNode = concatNode;
        }
        SQLQueryItemList queryItemList = qBlock.getQueryItemList();
        for (SQLQueryItem qItem : queryItemList) {
            String name = qItem.getBaseColumnName();
            if (name == null) {
                name = qItem.getName();
            }
            rowsetInfo.addColumnInfo(new ColumnInfo(name, qItem.getDataType()));
        }
        xNode.setRowsetInfo(rowsetInfo);
        xNode.addChild((IXQEQueryNode)qNode);
        XValueDecoration valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043);
        if (valueDecorationNode != null && valueDecorationNode.isVectorized()) {
            xNode.setVectorizationContext(new XVectorContext(rowsetInfo.getNumColumns()));
        }
        node.exchange(xNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean lazyLoading = configuration.getBooleanProperty(QUERY_EXECUTION_O_DATA_LAZY_LOADING_VALUE, true);
        SQLQueryBlock qBlock = node.getType() == 301004 ? (SQLQueryBlock)node : (SQLQueryBlock)node.getAncestorOfType(301004);
        if (qBlock != null) {
            IDataSource dataSource = qBlock.getDataSource();
            boolean bl = status = dataSource != null && DataSourceTypeEnum.isOData(dataSource.getType());
            if (status) {
                status = node.getType() == 301038 ? !qBlock.isForeign() && lazyLoading && ((SQLTableFunction)node).getSubType() == SQLTableFunction.SubType.UNNEST : qBlock.isForeign();
            }
        }
        if (status) {
            this.traceQueryCondition(status, "HTTP GET request is required.", trace);
        } else {
            this.traceQueryCondition(status, "HTTP GET request is not required.", trace);
        }
        return status;
    }

    private boolean isSQLFilePathSet(IRequestEnvironment environment) {
        String path = environment.getSqlFilePath();
        return path != null && !path.equals("");
    }

    private ArrayList<ParameterInfo> generateParamInfoList(IXQEQueryNode node) {
        ArrayList<ParameterInfo> paramInfoList = new ArrayList<ParameterInfo>();
        List<IXQEQueryNode> params = node.getDescendantsOfTypeOrdered(301051, 301004);
        this.checkForConflictsWithReservedParameters(params);
        for (SQLParameter sQLParameter : params) {
            if (sQLParameter.getModelFilterItem() == null) continue;
            ParameterInfo paramInfo = new ParameterInfo(sQLParameter.getName());
            if (sQLParameter.getValuePrefix() != null) {
                paramInfo.setValuePrefix(sQLParameter.getValuePrefix());
            }
            if (sQLParameter.getValueSuffix() != null) {
                paramInfo.setValueSuffix(sQLParameter.getValueSuffix());
            }
            paramInfo.setUseParameterizedSQL(sQLParameter.getUseParameterizedSQL());
            paramInfoList.add(paramInfo);
        }
        return paramInfoList;
    }

    private void checkForConflictsWithReservedParameters(List<IXQEQueryNode> params) {
        HashSet<String> internalParams = new HashSet<String>();
        HashSet<String> promptParams = new HashSet<String>();
        for (SQLParameter sQLParameter : params) {
            if (sQLParameter.getModelFilterItem() != null) {
                if (internalParams.contains(sQLParameter.getName())) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_ConflictedPromptParameterName, sQLParameter.getName());
                }
                promptParams.add(sQLParameter.getName());
                continue;
            }
            if (promptParams.contains(sQLParameter.getName())) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_ConflictedPromptParameterName, sQLParameter.getName());
            }
            internalParams.add(sQLParameter.getName());
        }
    }
}

