/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IScalarFunction;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.XScalarFunction;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;

public final class GenerateXScalarFunction
extends RQETransformation {
    public GenerateXScalarFunction() {
        this.mName = "Generate XScalarFunction node.";
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{301026, 301027, 301025, 301047, 301045, 301033, 301024, 301064, 301063, 301044, 301035, 301071, 301072, 301073, 301074, 301075, 301076, 301077, 301095, 301046};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] children;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLAbstractFunction fNode = (SQLAbstractFunction)node;
        IDataType[] argumentTypes = fNode.getParameterTypes();
        for (IXQEQueryNode child : children = fNode.getChildrenOfType(301030)) {
            child.extract();
        }
        for (IXQEQueryNode child : children = fNode.getChildrenOfType(301048)) {
            child.extract();
        }
        if (node.getType() == 301075) {
            for (int i = 0; i < argumentTypes.length; ++i) {
                if (!argumentTypes[i].isBlob()) continue;
                throw new XQERuntimeException(XQEMessageKeys.PLN_BlobNotAllowedIsDistinctFrom);
            }
        }
        if (node.getType() == 301047 || node.getType() == 301033 && ((SQLFunction)node).getSubType() == SQLFunction.SubType.XMLSERIALIZE) {
            node.getFirstChildByType(301037).extract();
        }
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        messageContext.add(node);
        IScalarFunction function = (IScalarFunction)FunctionManager.getFunction(fNode.getFunctionName(), argumentTypes, fNode.isUdf());
        if (null == function) {
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedFunction, fNode.getFunctionName(), messageContext);
            throw new XQEOlapUnsupportedQueryException(message);
        }
        function.validateArgumentTypes(argumentTypes);
        if (!GenerateXScalarFunction.hasVariantArguments(argumentTypes)) {
            function.validateArgumentTypesImpl(argumentTypes);
        }
        XScalarFunction xNode = (XScalarFunction)nodeFactory.createXNode(501020);
        xNode.setFunction(function);
        xNode.setDataType(function.getResultDataType(argumentTypes));
        if (fNode.getType() == 301047 || fNode.getType() == 301033) {
            xNode.setOnErrorPolicy(fNode.getOnErrorPolicy());
        }
        node.exchange(xNode, true);
    }

    private static boolean hasVariantArguments(IDataType[] argumentTypes) {
        boolean result = false;
        for (int i = 0; i < argumentTypes.length && !result; ++i) {
            result = argumentTypes[i].getCCLTypeCode() == 22;
        }
        return result;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        boolean bl = status = querySet == null || querySet.getBooleanPropertyValue("vectorizable", false) == false || node.getAncestorOfType(301040) != null;
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getFirstChildByType(301055) == null && (node.getType() != 301076 || node.getChild(1).getType() != 301059);
        if (status) {
            this.traceQueryCondition(status, "Node is not a quantified predicate", trace);
        } else {
            this.traceQueryCondition(status, "Node is a quantified predicate.", trace);
        }
        return status;
    }
}

