/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSubQuery;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.runtree.relational.XSearch;
import com.cognos.xqe.runtree.relational.XSort;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;

public class GenerateXSearch
extends RQETransformation {
    public GenerateXSearch() {
        this.mName = "Generate XSearchNode node.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{301076};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        XSearch xSearch = (XSearch)factory.createXNode(501098);
        XSort xSort = (XSort)factory.createXNode(501012);
        xSort.setDistinct(true);
        int numberOfCols = 1;
        IDataType dType = ((SQLSubQuery)node.getChild(1)).getDataType();
        numberOfCols = ((RowType)dType).getNumberColumns();
        OrderBy[] orderByList = new OrderBy[numberOfCols];
        for (int i = 0; i < numberOfCols; ++i) {
            orderByList[i] = new OrderBy(i, true, SQLSortKey.NullOrdering.NULLS_LAST);
        }
        xSort.setSortKeyList(orderByList);
        node.getChild(1).exchange(xSort, true);
        if (xSort.getChild(0).getType() == 501022 || xSort.getChild(0).getType() == 301008) {
            xSort.getChild(0).extract();
        }
        node.exchange(xSearch, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getChild(1).getType() == 301059;
        if (status) {
            this.traceQueryCondition(status, "Comparison node is an IN predicate.", trace);
        } else {
            this.traceQueryCondition(status, "Comparison node is not an IN predicate.", trace);
        }
        return status;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XValueDecoration valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043);
        boolean bl = status = valueDecorationNode == null || !valueDecorationNode.isVectorized();
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        }
        return status;
    }
}

