/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.ISetFunction;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.XValueComparator;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.ArrayList;

public final class GenerateXSetFunction
extends RQETransformation {
    public GenerateXSetFunction() {
        this.mName = "Generate XSetFunction node.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{301034};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLAggregate fNode = (SQLAggregate)node;
        int nChildren = fNode.getNumberChildren();
        XSetFunction xNode = (XSetFunction)nodeFactory.createXNode(501038);
        IDataType[] argumentTypes = new IDataType[nChildren];
        for (int i = 0; i < nChildren; ++i) {
            argumentTypes[i] = fNode.getChild(i) instanceof SQLValueList ? ((IXExpression)((Object)fNode.getChild(i).getChild(0))).getDataType() : ((IXExpression)((Object)fNode.getChild(i))).getDataType();
        }
        ISetFunction function = (ISetFunction)FunctionManager.getFunction(fNode.getFunctionName(), argumentTypes, fNode.isUdf());
        if (null == function) {
            ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
            messageContext.add(node);
            if (fNode.isUdf()) {
                XQEMessage message = new XQEMessage(XQEMessageKeys.UDF_AggregateFunctionNotFound, fNode.getFunctionName(), messageContext);
                throw new XQEOlapUnsupportedQueryException(message);
            }
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedFunction, fNode.getFunctionName(), messageContext);
            throw new XQEOlapUnsupportedQueryException(message);
        }
        XValueComparator xComparator = (XValueComparator)fNode.getFirstDescendantOfTypeOrdered(501083, false);
        if (xComparator != null) {
            function.setComparator(xComparator.getComparator());
        }
        function.setDistinct(fNode.isDistinct());
        xNode.setFunction(function);
        xNode.setDataType(function.getResultDataType(argumentTypes));
        node.exchange(xNode, true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XValueDecoration valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043);
        boolean bl = status = valueDecorationNode == null || !valueDecorationNode.isVectorized();
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] windows = node.getChildrenOfType(301041);
        boolean bl = status = windows.length == 0;
        if (status) {
            this.traceQueryCondition(status, " The function is a standard aggregate", trace);
        } else {
            this.traceQueryCondition(status, " The function is windowed aggregate", trace);
        }
        return status;
    }
}

