/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLOrdinal;
import com.cognos.xqe.ast.sql.SQLSort;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.runtree.relational.XSort;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GenerateXSort
extends RQETransformation {
    private static final String NULLVALUESORTING = "nullValueSorting";
    private static final String UNSPECIFIED = "unspecified";
    private static final String DATASOURCE = "dataSource";

    public GenerateXSort() {
        this.mName = "Generate XSort node.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{301019};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        GenerateXSort.setNullOrderingProperty(node, environment);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        XSort xNode = (XSort)nodeFactory.createXNode(501012);
        SQLSortKeyList sortKeyList = (SQLSortKeyList)node.detachChild(1);
        int nSortKeys = sortKeyList.getNumberChildren();
        OrderBy[] orderByList = new OrderBy[nSortKeys];
        for (int i = 0; i < nSortKeys; ++i) {
            SQLSortKey sortKey = (SQLSortKey)sortKeyList.getChild(i);
            if (sortKey.getDataType().isBlob()) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_GroupByNotAllowed);
            }
            IXQEQueryNode child = sortKey.getChild(0);
            SQLSortKey.NullOrdering nullOrder = sortKey.getNullOrder();
            if (node.getParent().getType() == 901014 && nullOrder == SQLSortKey.NullOrdering.UNSPECIFIED) {
                nullOrder = SQLSortKey.NullOrdering.NULLS_FIRST;
            }
            if (child.getType() == 301032) {
                SQLFid fid = (SQLFid)child;
                orderByList[i] = new OrderBy(fid.getVirtualColumnNo(), sortKey.isAscending(), nullOrder);
                continue;
            }
            if (child.getType() != 301066) continue;
            SQLOrdinal ordinal = (SQLOrdinal)child;
            int virtualColumnNo = ordinal.getValue() - 1;
            orderByList[i] = new OrderBy(virtualColumnNo, sortKey.isAscending(), nullOrder);
        }
        xNode.setDistinct(((SQLSort)node).isDistinct());
        xNode.setSortKeyList(orderByList);
        node.exchange(xNode, true);
        int[] ancestorsToSortByMUN = new int[]{501034, 501143, 901014, 901022};
        if (xNode.getAncestorOfTypes(ancestorsToSortByMUN) != null) {
            xNode.setSortMemberByCaption(false);
        }
    }

    public static void setNullOrderingProperty(IXQEQueryNode node, IPlanningEnvironment environment) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        IXQEQueryNode[] sortKeyNodes = node.getDescendantsOfType(301020, true);
        MetadataConnection mdConnection = (MetadataConnection)environment.getMetadataConnection();
        List<IModelDataSource> modelDSs = mdConnection.getModelDataSources();
        if (modelDSs != null) {
            Set<Object> dataSources = new HashSet();
            IXQEQueryNode querySet = node.getAncestorOfType(101002);
            if (querySet != null) {
                dataSources = ((V5QuerySet)querySet).getDataSources();
            }
            if (querySet == null || dataSources == null) {
                dataSources = new HashSet();
                for (IModelDataSource modelDS : modelDSs) {
                    String modelDSCMName = modelDS.getCMDataSourceName();
                    if (MacroExpander.isMacro(modelDSCMName)) {
                        MacroExpander me = new MacroExpander();
                        modelDSCMName = me.expand(null, environment, modelDSCMName);
                    }
                    if (modelDSCMName == null) continue;
                    IDataSource ds = execEnv.getDataSource(modelDSCMName);
                    dataSources.add(ds);
                }
            }
            if (dataSources != null) {
                Iterator<Object> dataSourcesIter = dataSources.iterator();
                Iterator<IModelDataSource> modelDataSourcesIter = modelDSs.iterator();
                if (dataSources.size() == 1) {
                    IModelDataSource modelDS = null;
                    IDataSourceCapabilities capabilities = null;
                    while (dataSourcesIter.hasNext()) {
                        IDataSource dataSource = (IDataSource)dataSourcesIter.next();
                        if (!dataSource.isRelational()) continue;
                        String datasourceCMName = dataSource.getCMDataSourceName();
                        while (modelDataSourcesIter.hasNext()) {
                            modelDS = modelDataSourcesIter.next();
                            String modelDataSourceCMName = modelDS.getCMDataSourceName();
                            if (MacroExpander.isMacro(modelDataSourceCMName)) {
                                MacroExpander me = new MacroExpander();
                                modelDataSourceCMName = me.expand(null, environment, modelDataSourceCMName);
                            }
                            if (!datasourceCMName.equals(modelDataSourceCMName)) continue;
                            capabilities = dataSource.getCapabilities();
                            Map<String, Object> properties = modelDS.getMetadataProperties();
                            if (properties != null && properties.get(NULLVALUESORTING) != null && !properties.get(NULLVALUESORTING).toString().equals(UNSPECIFIED)) continue;
                            for (IXQEQueryNode sortKeyNode : sortKeyNodes) {
                                SQLSortKey sortKey = (SQLSortKey)sortKeyNode;
                                if (sortKey.getNullOrder() != SQLSortKey.NullOrdering.UNSPECIFIED) continue;
                                GenerateXSort.setNullOrder(capabilities, sortKey);
                            }
                            return;
                        }
                    }
                }
                if (dataSources.size() > 1) {
                    for (IXQEQueryNode sortKeyNode : sortKeyNodes) {
                        SQLSortKey sortKey = (SQLSortKey)sortKeyNode;
                        if (sortKey.getNullOrder() != SQLSortKey.NullOrdering.UNSPECIFIED) continue;
                        IDataSourceCapabilities capabilities = null;
                        SQLFid sqlFid = (SQLFid)sortKey.getFirstChildByType(301032);
                        IModelDataSource modelDS = (IModelDataSource)sqlFid.getPropertyValue(DATASOURCE);
                        if (modelDS == null) continue;
                        Map<String, Object> properties = modelDS.getMetadataProperties();
                        while (dataSourcesIter.hasNext()) {
                            IDataSource dataSource = (IDataSource)dataSourcesIter.next();
                            if (!dataSource.isRelational()) continue;
                            String modelDataSourceCMName = modelDS.getCMDataSourceName();
                            if (MacroExpander.isMacro(modelDataSourceCMName)) {
                                MacroExpander me = new MacroExpander();
                                modelDataSourceCMName = me.expand(null, environment, modelDataSourceCMName);
                            }
                            if (!modelDataSourceCMName.equals(dataSource.getCMDataSourceName())) continue;
                            capabilities = dataSource.getCapabilities();
                            if (capabilities != null && (properties.get(NULLVALUESORTING) == null || properties.get(NULLVALUESORTING).toString().equals(UNSPECIFIED))) {
                                GenerateXSort.setNullOrder(capabilities, sortKey);
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    private static void setNullOrder(IDataSourceCapabilities capabilities, SQLSortKey sortKey) {
        if (capabilities.isSupported("general.nullsAreSortedLow")) {
            if (sortKey.isAscending()) {
                sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_FIRST);
            } else {
                sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
            }
        }
        if (capabilities.isSupported("general.nullsAreSortedHigh")) {
            if (sortKey.isAscending()) {
                sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
            } else {
                sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_FIRST);
            }
        }
        if (sortKey.getNullOrder() == SQLSortKey.NullOrdering.UNSPECIFIED && capabilities.isSupported("general.nullsAreSortedAtStart")) {
            sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_FIRST);
        }
        if (sortKey.getNullOrder() == SQLSortKey.NullOrdering.UNSPECIFIED && capabilities.isSupported("general.nullsAreSortedAtEnd")) {
            sortKey.setNullOrder(SQLSortKey.NullOrdering.NULLS_LAST);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        XValueDecoration valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043);
        boolean bl = status = valueDecorationNode == null || !valueDecorationNode.isVectorized();
        if (status) {
            this.traceQueryCondition(status, "Vectorized query execution is not applicable.", trace);
        } else {
            this.traceQueryCondition(status, "Vectorized query execution is applicable.", trace);
        }
        return status;
    }
}

