/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.util.SQLPlainQueryFormatter;
import com.cognos.xqe.ast.sql.util.SQLPrettyPrintQueryFormatter;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.hooks.HookEvent;
import com.cognos.xqe.hooks.HookManager;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.parameters.ParameterInfo;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.rsapi.IRSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.relational.XFlintSql;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQETransformation;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.util.RQEUtil;
import com.cognos.xqe.transformation.runtree.relational.GenerateCursorReference;
import com.cognos.xqe.transformation.runtree.relational.GenerateXSql;
import com.cognos.xqe.transformation.v5tocogsql.util.MDOLogger;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.FileHandler;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.tuple.Pair;

public final class GenerateXSqlForFlint
extends RQETransformation {
    protected static final String HEADER = "\r\n\r\n\r\nNative SQL:\r\n";
    private static final String UNDERSCORE = "_";

    public GenerateXSqlForFlint() {
        this.mName = "Generate XFlintSql node.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{301004};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode[] comparisonNodes;
        XValueDecoration valueDecorationNode;
        SQLPrettyPrintQueryFormatter formatter;
        XQENodeFactory factory = environment.getNodeFactory();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
        boolean isLateral = qBlock.isLateralDerivedTable();
        String qBlockName = qBlock.getName();
        qBlock.setName(null);
        qBlock.setLateral(false);
        if (environment.isBigSQL()) {
            IXQEQueryNode parent = node.getParent();
            if (parent.getType() == 401005) {
                V5QuerySet querySet = (V5QuerySet)parent.getParent();
                querySet.setQueryItemList(((SQLQueryBlock)node).getQueryItemList());
            }
            this.addLocalAccessModeHint(qBlock);
        }
        this.modifySQLRelationNodesTableNames(qBlock);
        IDataSource dataSource = qBlock.getDataSource();
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        Object reqEnv = environment.getRequestEnvironment();
        boolean doPrettyPrint = GenerateXSqlForFlint.doPrettyPrint(node, environment);
        Properties props = new Properties();
        props.setProperty("nativeSQL", "true");
        props.setProperty("printDbName", "false");
        String comments = null;
        RSAPIDataset dataSet = (RSAPIDataset)node.getAncestorOfType(401005);
        if (dataSet != null) {
            comments = dataSet.getSQLComments();
            if (null != comments) {
                comments = GenerateXSqlForFlint.addDelimitersToComment(comments, capabilities);
            }
            if (node.hasDescendantOfType(301092, false)) {
                dataSet.setHasSampledData();
            }
        }
        if (qBlock.getChildren().length == 1 && qBlock.getChild(0).getType() == 301016) {
            RQEUtil.convertRelationIntoDerivedTable(qBlock, qBlockName, factory);
        }
        String sqlQuery = null;
        if (doPrettyPrint) {
            formatter = new SQLPrettyPrintQueryFormatter(props);
            qBlock.accept(formatter, dataSource.getCapabilities());
            sqlQuery = ((Object)formatter).toString();
            int maxQueryLength = dataSource.getCapabilities().getIntegerValue("limits.maxStatementLength", 0);
            if (maxQueryLength > 0 && sqlQuery.length() >= maxQueryLength) {
                sqlQuery = null;
            }
        }
        if (sqlQuery == null) {
            formatter = new SQLPlainQueryFormatter(props);
            qBlock.accept(formatter, dataSource.getCapabilities());
            sqlQuery = ((QueryFormatter)formatter).bufferToString();
        }
        if (GenerateXSqlForFlint.isSQLFilePathSet(reqEnv)) {
            String path = reqEnv.getSqlFilePath();
            FileHandler.appendToFile(path, HEADER);
            FileHandler.appendToFile(path, "\r\n");
            if (comments != null) {
                FileHandler.appendToFile(path, comments);
            }
            FileHandler.appendToFile(path, "\r\n");
            FileHandler.appendToFile(path, sqlQuery);
            FileHandler.appendToFile(path, "\r\n");
            FileHandler.appendToFile(path, "\r\n");
        }
        MDOLogger.logMDONativeSQL(environment, dataSet, sqlQuery);
        List<IXQEQueryNode> params = node.getDescendantsOfTypeOrdered(301051, 301004);
        for (int i = 0; i < params.size(); ++i) {
            SQLParameter param = (SQLParameter)params.get(i);
            if (param.getParent().getType() == 301016) continue;
            ParameterInfo paramInfo = new ParameterInfo(param.getName());
            if (param.getValuePrefix() != null) {
                paramInfo.setValuePrefix(param.getValuePrefix());
            }
            if (param.getValueSuffix() != null) {
                paramInfo.setValueSuffix(param.getValueSuffix());
            }
            paramInfo.setUseParameterizedSQL(param.getUseParameterizedSQL());
            qBlock.addToParamInfoListForSubstitution(paramInfo);
        }
        IXQEQueryNode ancestor = node.getAncestorOfTypes(new int[]{301059, 301055, 901010});
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        Governors governors = null;
        if (dataSet != null) {
            governors = dataSet.getGovernors();
        }
        boolean cacheable = ancestor == null && !isLateral && querySet != null && !querySet.isNonReusable() && governors != null && governors.isLocalCacheEnabled(environment) != false;
        List<String> columnNames = qBlock.getColumnNames();
        String dbPlan = null;
        if (QueryEngineLoggingUtils.isPlanningTraceEnabled(reqEnv) || QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv)) {
            Object execEnv = reqEnv.getExecutionEnvironment();
            IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection(execEnv, dataSource);
            Object conn = pooledConnection.getConnection();
            if (conn instanceof JDBCConnection) {
                JDBCConnection connection = (JDBCConnection)conn;
                try {
                    dbPlan = connection.explain(sqlQuery);
                }
                catch (SQLException e) {
                    dbPlan = String.format("<exception><![CDATA[%s]]></exception>", e.getLocalizedMessage());
                }
            }
            pooledConnection.returnConnection();
        }
        RowsetInfo calculatedRowsetInfo = new RowsetInfo();
        SQLQueryItemList columns = qBlock.getQueryItemList();
        if (columns != null) {
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                calculatedRowsetInfo.addColumnInfo(new ColumnInfo((SQLQueryItem)iterator.next()));
            }
        } else {
            SQLValueList vlist = qBlock.getOutputList();
            if (vlist != null) {
                IXQEQueryNode[] selectables = vlist.getChildren();
                for (int i = 0; i < selectables.length; ++i) {
                    calculatedRowsetInfo.addColumnInfo(new ColumnInfo("C1", ((SQLQueryNode)selectables[i]).getDataType()));
                }
            }
        }
        String querySpecificationSQL = this.generateNativeQuerySpecificationText(qBlock, comments);
        XFlintSql xNode = (XFlintSql)factory.createXNode(501207);
        xNode.setDataSource(dataSource);
        xNode.setPromotedDatasources(this.extractFlintPromotedDatasources(qBlock));
        xNode.setColumnNames(columnNames);
        xNode.setSqlText(sqlQuery);
        xNode.setDBQueryPlan(dbPlan);
        xNode.setParamInfoListForSubstitution(qBlock.getParamInfoListForSubstitution());
        xNode.setCacheable(cacheable);
        xNode.setCalculatedRowsetInfo(calculatedRowsetInfo);
        xNode.setQuerySpecificationSQL(querySpecificationSQL);
        xNode.setCommentText(comments);
        xNode.setNullOrdering(qBlock.getNullOrdering());
        this.processSamplingProperties(qBlock, xNode);
        if (governors != null && governors.isStatsQuery()) {
            xNode.setIsStatsQuery(governors.isStatsQuery());
        }
        if ((valueDecorationNode = (XValueDecoration)node.getAncestorOfType(501043)) != null && node.getParent() != valueDecorationNode && valueDecorationNode.isVectorized()) {
            xNode.setVectorizationContext(new XVectorContext(calculatedRowsetInfo.getNumColumns()));
        }
        if (HookManager.hooksDefined(HookEvent.JDBC_PREPARE) || xqeConfig.connectionAttributesEnabled()) {
            xNode.setSQLAst((SQLQueryNode)factory.deepCopyNodeNonIndexed(qBlock.getChild(0)));
            xNode.getSQLAst().setPropertyValue("applicationContext", this.addApplicationContext(xNode.getSQLAst(), environment));
        }
        if (qBlock.getReusableQuery() != null) {
            qBlock.getChild(0).exchange(xNode);
            GenerateCursorReference.doTransformation(node, environment);
            if ((reqEnv.isValidateRequest() || reqEnv.isMixedRequest()) && reqEnv.getMaxSeverityLevel() == 2 && dataSet.queryFeedbackIsRequested("nativeCommandText")) {
                dataSet.getExecutionSQLCursors().addSQLCursorText(qBlock.getReusableQuery().toString(), sqlQuery);
            }
        } else {
            node.exchange(xNode);
        }
        for (IXQEQueryNode comparison : comparisonNodes = qBlock.getDescendantsOfType(301026, false)) {
            String linkName = ((SQLComparison)comparison).getMasterDetailLinkName();
            if (linkName == null) continue;
            xNode.addDetailQueryFilterName(linkName);
            break;
        }
    }

    private String generateNativeQuerySpecificationText(SQLQueryBlock qBlock, String comment) {
        IRSAPIDataset dataSet = (IRSAPIDataset)qBlock.getAncestorOfType(401005);
        if (dataSet == null) {
            return null;
        }
        if (!dataSet.queryFeedbackIsRequested("nativeQuerySpecificationText")) {
            return null;
        }
        IDataSource dataSource = qBlock.getDataSource();
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        Properties props = new Properties();
        props.setProperty("querySQL", "true");
        if (null != comment) {
            comment = GenerateXSqlForFlint.addDelimitersToComment(comment, capabilities);
            props.setProperty("comment", comment);
        }
        SQLPrettyPrintQueryFormatter formatter = new SQLPrettyPrintQueryFormatter(props);
        qBlock.accept(formatter, dataSource.getCapabilities());
        String querySpecificationSql = ((Object)formatter).toString();
        return querySpecificationSql;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        SQLQueryBlock qBlock = (SQLQueryBlock)node;
        SQLQueryBlock pBlock = (SQLQueryBlock)node.getAncestorOfType(301004);
        IDataSource dataSource = qBlock.getDataSource();
        boolean bl = status = dataSource != null && DataSourceTypeEnum.isFlint(dataSource.getType()) && qBlock.getBlockType() != 301061 && qBlock.isForeign() && (pBlock == null || !pBlock.isForeign());
        if (status) {
            this.traceQueryCondition(status, "Query block is foreign.", trace);
        } else {
            this.traceQueryCondition(status, "Query block is not foreign.", trace);
        }
        return status;
    }

    public static boolean isSQLFilePathSet(IRequestEnvironment environment) {
        String path = environment.getSqlFilePath();
        return path != null && !path.equals("");
    }

    public static String addDelimitersToComment(String comment, IDataSourceCapabilities capabilities) {
        StringBuilder builder = new StringBuilder();
        String commentBegin = capabilities.getStringValue("delimiters.commentBegin", null);
        String commentEnd = capabilities.getStringValue("delimiters.commentEnd", null);
        if (commentBegin == null || commentEnd == null || commentBegin.isEmpty() || commentEnd.isEmpty()) {
            return "";
        }
        builder.append(commentBegin);
        builder.append(" ");
        builder.append(comment);
        builder.append(" ");
        builder.append(commentEnd);
        builder.append(" ");
        comment = builder.toString();
        return comment;
    }

    public static boolean doPrettyPrint(IXQEQueryNode node, IPlanningEnvironment environment) {
        if (environment.isBigSQL()) {
            return false;
        }
        String prettyPrint = "queryExecution.prettyPrintNativeSQL[@enabled]";
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        RSAPIDataset dataSet = (RSAPIDataset)node.getAncestorOfType(401005);
        if (GenerateXSqlForFlint.isSQLFilePathSet(reqEnv) || dataSet == null) {
            return environment.getMultiRequestContext().fetchBooleanConfiguration(prettyPrint, true);
        }
        if (reqEnv.isValidateRequest() && (reqEnv.getMaxSeverityLevel() == 2 || reqEnv.getMaxSeverityLevel() == 3) || dataSet.queryFeedbackIsRequested("nativeCommandText")) {
            return true;
        }
        return environment.getMultiRequestContext().fetchBooleanConfiguration(prettyPrint, false);
    }

    private void addLocalAccessModeHint(SQLQueryBlock qBlock) {
        IXQEQueryNode root = qBlock.getChild(0);
        if (root.getType() == 301060) {
            root = root.getChild(0);
        }
        if (root.getType() == 301015 && GenerateXSql.relationProjected(root.getChild(0))) {
            boolean isSimple = true;
            SQLValueList vList = ((SQLProject)root).getOutputList();
            IXQEQueryNode[] nodes = vList.getDescendantsOfTypes(new int[]{301034, 301059}, false);
            if (nodes.length > 0) {
                isSimple = false;
            } else {
                for (IXQEQueryNode funcNode : nodes = vList.getDescendantsOfTypes(new int[]{301033}, false)) {
                    if (((SQLFunction)funcNode).getSubType() != SQLFunction.SubType.UDF) continue;
                    isSimple = false;
                    break;
                }
            }
            qBlock.setIsSimple(isSimple);
        }
    }

    private Properties addApplicationContext(SQLQueryNode ast, IPlanningEnvironment pEnv) {
        Properties context = new Properties();
        MacroExpander expander = new MacroExpander();
        RequestEnvironment reqEnv = (RequestEnvironment)pEnv.getRequestEnvironment();
        ParameterAccessCoordinator pac = reqEnv.getParameterAccessCoordinator((PlanningEnvironment)pEnv);
        context.setProperty("user", expander.expand(ast, pEnv, pac, "#$account.defaultName#", 5));
        context.setProperty("reportName", expander.expand(ast, pEnv, pac, "#$report#", 5));
        context.setProperty("reportPath", expander.expand(ast, pEnv, pac, "#$reportPath#", 5));
        context.setProperty("queryName", expander.expand(ast, pEnv, pac, "#$queryName#", 5));
        context.setProperty("modelPath", expander.expand(ast, pEnv, pac, "#$modelPath#", 5));
        context.setProperty("hostName", expander.expand(ast, pEnv, pac, "#$REMOTE_ADDR#", 5));
        context.setProperty("serverName", expander.expand(ast, pEnv, pac, "#$SERVER_NAME#", 5));
        context.setProperty("packageName", expander.expand(ast, pEnv, pac, "#$packageName#", 5));
        context.setProperty("applicationClass", " BI");
        context.setProperty("version", "A2");
        return context;
    }

    private void modifySQLRelationNodesTableNames(SQLQueryBlock currentQBlock) {
        IXQEQueryNode[] nodes;
        for (IXQEQueryNode node : nodes = currentQBlock.getDescendantsOfType(301016, false)) {
            IXQEQueryNode[] fids;
            IXQEQueryNode rangeVar;
            SQLRelation sqlRelNode = (SQLRelation)node;
            if (sqlRelNode.isWithClauseQueryRef()) continue;
            IDataSource ds = sqlRelNode.getDataSource();
            String logicalName = (String)ds.getMetadataProperties().get("dsLogicalName");
            String flintTableName = "ft" + sqlRelNode.getModelDatasourceName();
            if (null != logicalName) {
                flintTableName = flintTableName + UNDERSCORE + logicalName;
            }
            sqlRelNode.setName(flintTableName.replaceAll("\\.", UNDERSCORE).replaceAll("\\s+", UNDERSCORE));
            sqlRelNode.setTableName(null);
            sqlRelNode.setExternalName(null);
            if (!sqlRelNode.getBooleanPropertyValue("SamplingQueryHintApplied", false).booleanValue() || null == (rangeVar = sqlRelNode.getAncestorOfType(301007))) continue;
            for (IXQEQueryNode fid : fids = rangeVar.getDescendantsOfType(301032, true)) {
                SQLFid currentFid = (SQLFid)fid;
                currentFid.setTableName(null);
            }
        }
    }

    private List<Pair<String, IDataSource>> extractFlintPromotedDatasources(SQLQueryBlock currentQBlock) {
        IXQEQueryNode[] nodes;
        LinkedList<Pair<String, IDataSource>> result = new LinkedList<Pair<String, IDataSource>>();
        for (IXQEQueryNode node : nodes = currentQBlock.getDescendantsOfType(301016, false)) {
            SQLRelation sqlRelNode = (SQLRelation)node;
            if (sqlRelNode.isWithClauseQueryRef()) continue;
            result.add((Pair<String, IDataSource>)Pair.of((Object)sqlRelNode.getModelDatasourceName(), (Object)sqlRelNode.getDataSource()));
        }
        return result;
    }

    private void processSamplingProperties(SQLQueryBlock currentQBlock, XFlintSql xFlintSql) {
        IXQEQueryNode[] nodes;
        for (IXQEQueryNode node : nodes = currentQBlock.getDescendantsOfType(301016, false)) {
            Double samplingPercent;
            SQLRelation sqlRelNode = (SQLRelation)node;
            if (sqlRelNode.isWithClauseQueryRef() || (samplingPercent = sqlRelNode.getDoublePropertyValue("tableSamplingPercent")) == null) continue;
            if (xFlintSql.getSamplingPercent() != null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedFeature, "Multiple Table Samples with Flint");
            }
            xFlintSql.setSamplingPercent(samplingPercent);
            xFlintSql.setSamplingSeed(sqlRelNode.getIntegerPropertyValue("tableSamplingSeed"));
        }
    }
}

