/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational.vectorization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFormat;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLOption;
import com.cognos.xqe.ast.sql.SQLValueExpression;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IScalarFunction;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.VectorOp;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorLiteral;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDecimalToDouble;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.relational.RQEVectorTransformation;
import java.math.BigDecimal;
import java.util.ArrayList;

public final class GenerateXVectorExpression
extends RQEVectorTransformation {
    public GenerateXVectorExpression() {
        this.mName = "Generate vectorized operator.";
        this.mTypes = new int[]{301045, 301047, 301026, 301063, 301033, 301075, 301024, 301044, 301027, 301071, 301064, 301025};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        IXQEQueryNode parent;
        SQLAbstractFunction fNode = (SQLAbstractFunction)node;
        IVectorContext dfNode = (IVectorContext)((Object)node.getAncestorOfCategory(301089));
        IDataType[] argumentTypes = fNode.getParameterTypes();
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        messageContext.add(node);
        IScalarFunction function = (IScalarFunction)FunctionManager.getFunction(fNode.getFunctionName(), argumentTypes, fNode.isUdf());
        if (null == function) {
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedFunction, fNode.getFunctionName(), messageContext);
            throw new XQEOlapUnsupportedQueryException(message);
        }
        function.validateArgumentTypes(argumentTypes);
        if (!GenerateXVectorExpression.hasVariantArguments(argumentTypes)) {
            function.validateArgumentTypesImpl(argumentTypes);
        }
        IDataType returnType = fNode.getDataType();
        XVectorContext vContext = dfNode.getVectorizationContext();
        GenerateXVectorExpression.generateImplicitCastOperators(environment, vContext, fNode);
        Class<?> clazz = fNode.getVectorClass();
        if (node.getType() == 301047 || node.getType() == 301033 && ((SQLFunction)node).getSubType() == SQLFunction.SubType.XMLSERIALIZE) {
            node.getFirstChildByType(301037).extract();
        }
        if (node.getType() == 301063) {
            node.getChild(0).detach();
        }
        if (node.getType() == 301033 && (((SQLFunction)node).getSubType() == SQLFunction.SubType.CURRENT_TIME || ((SQLFunction)node).getSubType() == SQLFunction.SubType.CURRENT_TIMESTAMP || ((SQLFunction)node).getSubType() == SQLFunction.SubType.LOCALTIME || ((SQLFunction)node).getSubType() == SQLFunction.SubType.LOCALTIMESTAMP) && node.getNumberChildren() > 0) {
            node.getChild(0).detach();
        }
        int nChildren = node.getNumberChildren();
        if (node.getType() == 301044 && nChildren == 2) {
            ++nChildren;
        }
        Object[] arguments = new Object[nChildren];
        IXQEQueryNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode child = children[i];
            if (child.getType() == 301050) {
                child.detach();
                arguments[i] = null;
                continue;
            }
            if (child.getType() == 301068) {
                arguments[i] = ((SQLOption)child.detach()).getValue();
                continue;
            }
            if (child.getType() == 301097) {
                arguments[i] = ((SQLFormat)child.detach()).getValue();
                continue;
            }
            if (child.getType() == 301031) {
                arguments[i] = XVectorContext.getObjectForLiteral((SQLLiteral)child.detach());
                continue;
            }
            if (child.getType() == 301032) {
                arguments[i] = ((SQLFid)child.detach()).getVirtualColumnNo();
                continue;
            }
            if (child.getType() == 301030) {
                int[] valuesInList = new int[child.getNumberChildren()];
                for (int j = 0; j < child.getNumberChildren(); ++j) {
                    valuesInList[j] = ((SQLFid)child.getChild(j)).getVirtualColumnNo();
                }
                child.detach();
                arguments[i] = valuesInList;
                continue;
            }
            arguments[i] = child.getType() == 501175 && node.getType() == 301071 ? ((XVectorLiteral)child.detach()).getValue() : Integer.valueOf(((XVectorExpression)child).getColumnNo());
        }
        VectorOp vectorOp = VectorOp.MAP;
        if (fNode.getAncestorOfTypeWithAnchor(301009, 301030) != null || fNode.getAncestorOfTypeWithAnchor(901013, 301030) != null) {
            vectorOp = VectorOp.SELECT;
        }
        XVectorExpression vExpr = XVectorContext.createVectorExpression(environment, vContext, clazz, vectorOp, returnType, arguments);
        if (node.getType() == 301047) {
            vExpr.setOnErrorPolicy(((SQLAbstractFunction)node).getOnErrorPolicy());
        }
        if ((node.getType() == 301024 || node.getType() == 301045 || node.getType() == 301044) && (parent = node.getParent()).getType() == 301027 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.NOT) {
            parent.extract();
        }
        node.exchange(vExpr, true);
    }

    private static boolean hasVariantArguments(IDataType[] argumentTypes) {
        boolean result = false;
        for (int i = 0; i < argumentTypes.length && !result; ++i) {
            result = argumentTypes[i].getCCLTypeCode() == 22;
        }
        return result;
    }

    private static void generateImplicitCastOperators(IPlanningEnvironment environment, XVectorContext vContext, SQLAbstractFunction fNode) {
        block13: {
            IDataType returnType;
            IDataType[] argTypes;
            IXQEQueryNode[] children;
            block14: {
                block12: {
                    if (fNode.getType() != 301025 && fNode.getType() != 301026 && fNode.getType() != 301071 && fNode.getType() != 301075) {
                        return;
                    }
                    XQENodeFactory factory = environment.getNodeFactory();
                    children = fNode.getChildren();
                    argTypes = fNode.getParameterTypes();
                    returnType = fNode.getDataType();
                    if (!returnType.isDecimal()) break block12;
                    int i = 0;
                    for (IXQEQueryNode child : children) {
                        if (!argTypes[i].exactlyEquivalent(returnType)) {
                            if (child.getType() == 301031) {
                                Value value = ((SQLLiteral)child).getValue();
                                BigDecimal decimalValue = value.getBigDecimal(returnType.getPrecision(), returnType.getScale());
                                int outputColumnNo = vContext.allocateOutputColumn(returnType);
                                XVectorLiteral vExpr = (XVectorLiteral)factory.createNode(501175);
                                vExpr.setDataType(returnType);
                                vExpr.setValue(outputColumnNo, decimalValue);
                                child.exchange(vExpr);
                            } else {
                                Class<?> castClass = SQLCast.getVectorClass(argTypes[i], returnType);
                                XVectorContext.generateCast(environment, vContext, children[i], castClass, returnType);
                            }
                        }
                        ++i;
                    }
                    break block13;
                }
                if (fNode.getType() != 301026 && fNode.getType() != 301075) break block14;
                if (!argTypes[0].isDecimal() && !argTypes[1].isDecimal() || argTypes[0].exactlyEquivalent(argTypes[1])) break block13;
                IDataType dType = DataTypeComparator.getCompatibleType(argTypes[0], argTypes[1]);
                for (int i = 0; i < children.length; ++i) {
                    if (argTypes[i].exactlyEquivalent(dType)) continue;
                    Class<?> castClass = SQLCast.getVectorClass(argTypes[i], dType);
                    XVectorContext.generateCast(environment, vContext, children[i], castClass, dType);
                }
                break block13;
            }
            if (fNode.getType() == 301025 && ((SQLValueExpression)fNode).getSubType() == SQLValueExpression.SubType.CONCATENATE) {
                int i = 0;
                for (IDataType dataType : argTypes) {
                    if (!dataType.isTextType()) {
                        Class<?> castClass = SQLCast.getVectorClass(argTypes[i], returnType);
                        XVectorContext.generateCast(environment, vContext, children[i], castClass, returnType);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                for (IDataType dataType : argTypes) {
                    if (dataType.isDecimal()) {
                        XVectorContext.generateCast(environment, vContext, children[i], XVectorCastDecimalToDouble.class, DataTypeFactory.getDoubleType());
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getAncestorOfType(301039) == null;
        if (status) {
            this.traceQueryCondition(status, "Expression is not in a table value constructor.", trace);
        } else {
            this.traceQueryCondition(status, "Expression is in a table value constructor.", trace);
        }
        return status;
    }
}

