/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.relational.vectorization;

import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.VectorOp;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.IVectorInList;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.RQEVectorTransformation;

public final class GenerateXVectorInList
extends RQEVectorTransformation {
    public GenerateXVectorInList() {
        this.mName = "Generate vectorized IN predicate.";
        this.mTypes = new int[]{301076};
    }

    @Override
    public void apply(IXQEQueryNode node, IPlanningEnvironment environment) {
        SQLAbstractFunction fNode = (SQLAbstractFunction)node;
        boolean notIn = false;
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 301027 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.NOT) {
            notIn = true;
            parent.extract();
        }
        parent = node.getParent();
        while (parent.getType() == 301027) {
            parent = parent.getParent();
        }
        boolean isFilter = parent.getType() == 301009;
        IVectorContext dfNode = (IVectorContext)((Object)node.getAncestorOfCategory(301089));
        XVectorContext vContext = dfNode.getVectorizationContext();
        Class<?> vClass = fNode.getVectorClass();
        Object[] arguments = new Object[2];
        IXQEQueryNode[] children = fNode.getChildren();
        IValueExpression exprNode = (IValueExpression)children[0];
        arguments[0] = exprNode.getType() == 301032 ? Integer.valueOf(((SQLFid)exprNode.detach()).getVirtualColumnNo()) : Integer.valueOf(((XVectorExpression)exprNode).getColumnNo());
        IDataType dataType = exprNode.getDataType();
        IXQEQueryNode vList = children[1].detach();
        Object[] valuesInList = new Object[vList.getNumberChildren()];
        for (int i = 0; i < vList.getNumberChildren(); ++i) {
            SQLLiteral literalNode = (SQLLiteral)vList.getChild(i);
            if (dataType.isNumeric() && literalNode.getDataType().isTextType()) {
                literalNode.setDataType(dataType);
                literalNode.setValue(literalNode.getValue().getString());
            }
            valuesInList[i] = XVectorContext.getObjectForLiteral(literalNode);
        }
        arguments[1] = valuesInList;
        VectorOp vectorOp = isFilter ? VectorOp.SELECT : VectorOp.MAP;
        IVectorInList vInList = (IVectorInList)((Object)XVectorContext.createVectorExpression(environment, vContext, vClass, vectorOp, DataTypeFactory.getBooleanType(), arguments));
        vInList.setNotIn(notIn);
        node.exchange(vInList, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, IPlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getChild(1).getType() == 301030;
        if (status) {
            this.traceNodeCondition(status, "SQLIn node can be converted to an XVectorInList operator.", trace);
        } else {
            this.traceNodeCondition(status, "The second child is not of type SQLValueList.", trace);
        }
        return status;
    }
}

