/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.v5.V5ShowAll;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public class CheckNestedLevelsForXV5ShowAll
extends Transformation {
    public CheckNestedLevelsForXV5ShowAll() {
        this.mName = "Identify CogMDXGroups targeted by showall and nested under the same hierarchy.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup targetGroup = (CogMDXGroup)node;
        throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedShowAllOnNestedLevels, targetGroup.getRefDataItemProperty());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup targetGroup = (CogMDXGroup)node;
        String reason = "Target group is not nested under the same hierarchy.";
        if (!targetGroup.isNestedLevels()) {
            this.traceNodeCondition(false, "Target group is not nested under the same hierarchy.", trace);
            return false;
        }
        IXQEQueryNode ancestorGroup = targetGroup.getParent();
        if (ancestorGroup.getType() != 1027 || !targetGroup.getFirstSetHierarchy().equals(((CogMDXGroup)ancestorGroup).getFirstSetHierarchy())) {
            this.traceNodeCondition(false, "Target group is not nested under the same hierarchy.", trace);
            return false;
        }
        V5ShowAll v5ShowAll = (V5ShowAll)targetGroup.getAncestorOfType(601028);
        if (v5ShowAll == null) {
            this.traceNodeCondition(false, "Show all is not applied to this query.", trace);
            return false;
        }
        MDXEdge edge = (MDXEdge)targetGroup.getAncestorOfType(1006);
        if (edge == null || !edge.isProjectedDescendant(targetGroup)) {
            this.traceNodeCondition(false, "The target CogMDXGroup node is not projected on an edge.", trace);
            return false;
        }
        String dataItemName = v5ShowAll.getShowAllRule(edge.getEdgeID()).getDataItemName();
        if (!targetGroup.getRefDataItemProperty().equals(dataItemName)) {
            this.traceNodeCondition(false, "Target group is not referencing the same data item as the show all.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Show all applied upon a dataItem nested under the same hierarchy.", trace);
        return true;
    }
}

