/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.runtree.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.v5.edgeupdate.XV5ExternalUpdate;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.cognos.xqe.resultsdk.util.PostProcessingFilterLoader;

public final class GenerateXV5ExternalUpdate
extends Transformation {
    public GenerateXV5ExternalUpdate() {
        this.mName = "Generates the XV5ExternalUpdate node for external result set update";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{401005};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataset rsapiDataset = (RSAPIDataset)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        XV5ExternalUpdate externalUpdate = (XV5ExternalUpdate)nodeFactory.createXNode(501163);
        externalUpdate.setPostProcessingFilter(PostProcessingFilterLoader.getPostProcessingFilter());
        rsapiDataset.getChild(0).getChild(0).insertParent(externalUpdate);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (PostProcessingFilterLoader.getPostProcessingFilter() != null) {
            if (node.getChild(0).getChild(0).getType() == 501163) {
                this.traceNodeCondition(false, "The transformation has already been applied.", trace);
                return false;
            }
            if (environment.getRequestEnvironment() != null && ((RequestEnvironment)environment.getRequestEnvironment()).isInternal()) {
                this.traceNodeCondition(false, "This is an internal query.", trace);
                return false;
            }
            this.traceNodeCondition(true, "The external result set update class has been configured.", trace);
            return true;
        }
        this.traceNodeCondition(false, "No external result set update class has been configured.", trace);
        return false;
    }
}

