/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.ParameterMapsApp;

public class AddRequestQueryHintIntoGovernors
extends Transformation {
    private boolean warm = false;

    public AddRequestQueryHintIntoGovernors() {
        this.mName = "Resolves Request & Query Hints into Governors";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Object dashboardHint;
        V5QuerySet querySet;
        V5Query query = (V5Query)node;
        String metadataPath = query.getMetadataPath();
        ParameterAccessCoordinator pac = ((RequestEnvironment)environment.getRequestEnvironment()).getParameterAccessCoordinator(environment, metadataPath);
        ParameterMapsApp hintMap = new ParameterMapsApp("_governor", IParameterMaps.EPRIORITY.CQE_REQUEST.getKey());
        if (query.containsQueryHints()) {
            for (V5Query.QueryHint queryHint : V5Query.QueryHint.values()) {
                String hintName = queryHint.getPropertyName();
                Object value = query.getPropertyValue(hintName);
                if (value == null) continue;
                if (value instanceof String) {
                    hintMap.set("_governor", hintName, (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    hintMap.set("_governor", hintName, Boolean.toString((Boolean)value));
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                hintMap.set("_governor", hintName, Integer.toString((Integer)value));
            }
        }
        if ((querySet = (V5QuerySet)query.getAncestorOfType(101002)).containsRequestHints()) {
            for (V5QuerySet.RequestHint requestHint : V5QuerySet.RequestHint.values()) {
                String hintName = requestHint.getPropertyName();
                Object value = querySet.getPropertyValue(hintName);
                if (value == null) continue;
                if (value instanceof String) {
                    hintMap.set("_governor", hintName, (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    hintMap.set("_governor", hintName, Boolean.toString((Boolean)value));
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                hintMap.set("_governor", hintName, Integer.toString((Integer)value));
            }
        }
        if (hintMap.getSize() > 0) {
            pac.addParameterMap(hintMap);
        }
        this.warmUpMetadataAccess(query.getMetadataConnectionMetadataPath(environment));
        Governors governors = new Governors();
        governors.loadGovernors(pac);
        String localCache = hintMap.get("_governor", V5Query.QueryHint.LOCAL_CACHE.getPropertyName());
        if (localCache != null) {
            governors.setLocalCacheSpecifiedInQueryHint("true");
        }
        if (query.getPropertyValue("sourceModule") != null && query.isTabular() && query.getPropertyValue("relationalSubquery") == null) {
            governors.setAutoSort(Governors.AutoSort.MINIMAL.toString());
        }
        if ((dashboardHint = query.getPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName())) != null) {
            governors.setInteractive();
        }
        query.setGovernors(governors);
        IXQEQueryNode[] nodes = querySet.getChildrenOfType(101055);
        for (int i = 0; i < nodes.length; ++i) {
            String queryName;
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)nodes[i];
            String refQueryName = qrd.getRefQueryProperty();
            if (!refQueryName.equals(queryName = query.getV5QueryName())) continue;
            qrd.setGovernors(governors);
        }
        ExecutionEnvironment executionEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        executionEnv.setGovernors(governors);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return node.getPropertyValue("governors") == null;
    }

    private void warmUpMetadataAccess(MetadataConnection mc) {
        if (!this.warm) {
            String xPath4Datasource = "/project//dataSource";
            mc.queryMetadata(xPath4Datasource);
            this.warm = true;
        }
    }
}

