/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Slicer;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AddSAPHierarchyVariableMembersSlicer
extends Transformation {
    public AddSAPHierarchyVariableMembersSlicer() {
        this.mName = "Add a slicer with a set of members from a selected hierarchy of the SAP hierarchy variable.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        Map<String, ParameterValues> sapHierachyVarsValues = this.getSAPHierVarValuelist(environment);
        ParameterValues parameterValues = null;
        IXQEQueryNode selectedMember = null;
        for (String variable : sapHierachyVarsValues.keySet()) {
            parameterValues = sapHierachyVarsValues.get(variable);
            parameterValues.setSAPHierVarialbeAddedToSlicer();
            V5Slicer slicerNode = null;
            XQEBaseQueryNode v5Set = null;
            for (ParameterValueItem valueItem : parameterValues) {
                selectedMember = valueItem.getBoundValue();
                if (selectedMember == null) {
                    Parameter associatedParameter = ((V5ParameterValueItem)valueItem).getAssociatedParameter();
                    associatedParameter.setDataType(DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE);
                    associatedParameter.setIsLiteral(false);
                    parameterValues.bind(environment);
                    selectedMember = valueItem.getBoundValue();
                }
                if (selectedMember == null) continue;
                if (v5Set == null) {
                    slicerNode = (V5Slicer)nodeFactory.createNode(101010);
                    v5Set = (V5SetFunction)nodeFactory.createNode(201101);
                    slicerNode.addChild(v5Set);
                    node.addChild(slicerNode);
                }
                v5Set.addChild(selectedMember);
            }
            environment.setTreeHasBeenModified();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        Map<String, ParameterValues> sapHierachyVarsValues = this.getSAPHierVarValuelist(environment);
        if (sapHierachyVarsValues == null || sapHierachyVarsValues.isEmpty()) {
            this.traceNodeCondition(false, "No SAP hierarchy varaible found.", trace);
            return false;
        }
        Iterator<String> varIterator = sapHierachyVarsValues.keySet().iterator();
        ParameterValues parameterValues = null;
        while (varIterator.hasNext()) {
            String variable = varIterator.next();
            parameterValues = sapHierachyVarsValues.get(variable);
            if (parameterValues.getSAPHierVarialbeAddedToSlicer() == null) continue;
            this.traceNodeCondition(false, "The V5Parameter nodes are already added to the V5Query.", trace);
            return false;
        }
        this.traceNodeCondition(true, "SAP hierarchy varaible found. Need to add a V5Parameter to the V5Query for furthere selected members of the selected hierarchy.", trace);
        return true;
    }

    private Map<String, ParameterValues> getSAPHierVarValuelist(PlanningEnvironment environment) {
        RequestParameters reqParameters = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().getRequestParameters();
        Parameters parameters = reqParameters.getParameters();
        if (parameters.isEmpty()) {
            return null;
        }
        Map<String, ParameterValues> valuesList = reqParameters.getParametersValueList();
        if (valuesList.isEmpty()) {
            return null;
        }
        List<IModelDataSource> dataSources = environment.getMetadataConnection().getModelDataSources();
        HashMap<String, ParameterValues> hierarchyVarsValues = new HashMap<String, ParameterValues>();
        ParameterValues values = null;
        for (IModelDataSource dataSource : dataSources) {
            List<IVariable> variables;
            ICube cube = dataSource.getCube();
            if (cube == null || (variables = cube.getVariables()) == null) continue;
            for (IVariable variable : variables) {
                String variableName = variable.getUniqueName();
                if (variable.getDataType() != DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE || !parameters.containsKey(variableName) || (values = valuesList.get(variableName)) == null || values.isEmpty()) continue;
                hierarchyVarsValues.put(variable.getName(), values);
            }
        }
        return hierarchyVarsValues;
    }
}

