/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import java.util.ArrayList;

public final class AddV5PropertyExpressionToV5Edge
extends Transformation {
    static final String PROPERTY_CONVERTED = "propertyExpConverted";
    private static final String[] PROPERTIES = new String[]{"_businessKey"};

    public AddV5PropertyExpressionToV5Edge() {
        this.mName = "Convert a V5RoleValueFunction node into a MDXProperties node.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{201098};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String itemName = null;
        String roleName = this.getRoleName(node);
        IXQEQueryNode grandParent = node.getParent().getParent();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        V5Query v5Query = qrd.getV5Query();
        V5Selection v5Selection = v5Query.getV5Selection();
        V5Edge edge = (V5Edge)node.getAncestorOfType(101049);
        IQueryItem queryItemProperty = null;
        if (grandParent != null) {
            if (grandParent.getType() == 101057) {
                itemName = ((V5ValueSet)grandParent).getRefDataItemProperty();
                V5DataItem item = v5Selection.getDataItemByRefName(itemName);
                IProperty propertyForRole = this.getRoleFromModel(item, roleName, environment);
                if (propertyForRole != null) {
                    queryItemProperty = (IQueryItem)((Object)propertyForRole);
                    edge.addDimensionPropertyList(queryItemProperty);
                }
            } else if (grandParent.getType() == 101051) {
                IXQEQueryNode[] dataItemRefs = grandParent.getChildrenOfTypeOrdered(101015);
                for (int i = 0; i < dataItemRefs.length; ++i) {
                    itemName = (String)dataItemRefs[i].getPropertyValue("refDataItem");
                    V5DataItem item = v5Selection.getDataItemByRefName(itemName);
                    IProperty propertyForRole = this.getRoleFromModel(item, roleName, environment);
                    if (propertyForRole == null) continue;
                    queryItemProperty = (IQueryItem)((Object)propertyForRole);
                    edge.addDimensionPropertyList(queryItemProperty);
                }
            }
        }
        node.setPropertyValue(PROPERTY_CONVERTED, Boolean.TRUE);
    }

    public IProperty getRoleFromModel(V5DataItem item, String roleName, PlanningEnvironment environment) {
        if (item == null) {
            return null;
        }
        MDXLevelInfo contextLevel = new MDXLevelInfo();
        IHierarchy hierarchy = item.getHierarchyInfo().getProjectedHierarchy(0);
        if (hierarchy == null || hierarchy.getDefaultMember() == null) {
            return null;
        }
        contextLevel.addProjectedHierarchy(hierarchy.getDefaultMember().getLevel());
        ArrayList<V5SimpleNode> fncs = new ArrayList<V5SimpleNode>();
        MDXLevelInfo levelInfo = item.getHierarchyLevelInfo(contextLevel, fncs);
        ILevel level = levelInfo.getProjectedLevel(hierarchy, 0);
        if (level == null) {
            return null;
        }
        IProperty propertyForRole = MetadataUtil.getPropertyByRole(level, roleName);
        return propertyForRole;
    }

    public String getRoleName(IXQEQueryNode node) {
        String roleName = null;
        IXQEQueryNode first = node.getChild(0);
        Value value = ((V5LiteralValue)first).getValue();
        if (value.getDataType().isTextType()) {
            roleName = value.toString();
        }
        return roleName;
    }

    public boolean isRolePreDefined(String roleName) {
        if (roleName == null) {
            return false;
        }
        boolean isPreDefined = false;
        for (int i = 0; i < PROPERTIES.length; ++i) {
            if (!roleName.equalsIgnoreCase(PROPERTIES[i])) continue;
            isPreDefined = true;
            break;
        }
        return isPreDefined;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        if (!super.passesQueryCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        boolean bl = status = !V5ToCogMDXUtilities.isDirectProjectedNode(node);
        if (status) {
            this.traceQueryCondition(status, "The node is not projected.", trace);
        } else {
            status = false;
            this.traceQueryCondition(status, "The node is projected.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getPropertyValue(PROPERTY_CONVERTED) != null) {
            this.traceNodeCondition(false, "Convertion already applied.", trace);
            return false;
        }
        IXQEQueryNode grandParent = node.getParent().getParent();
        if (grandParent == null || grandParent.getType() != 101057 && grandParent.getType() != 101051) {
            status = false;
            this.traceNodeCondition(status, "This is not a roleValue function used under valueset or groupBody.", trace);
        }
        String roleName = this.getRoleName(node);
        if (node.getNumberChildren() == 1) {
            IXQEQueryNode first = node.getChild(0);
            if (first.getType() == 201026) {
                if (this.isRolePreDefined(roleName)) {
                    status = true;
                    this.traceNodeCondition(status, "This is a roleValue function from propertyExpression.", trace);
                } else {
                    status = false;
                    this.traceNodeCondition(status, "The roleValue function is pre-defined.", trace);
                }
            } else {
                status = false;
                this.traceNodeCondition(status, "The roleValue function is not from propertyExpression.", trace);
            }
        }
        return status;
    }
}

