/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class AdjustMasterDetailFilter
extends Transformation {
    public AdjustMasterDetailFilter() {
        this.mName = "Adjust master-detail detail filters.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{201013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode lhsNode = node.getChild(0);
        lhsNode.insertParent(nodeFactory.createNode(201101));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5ComparisonExpression comparison = (V5ComparisonExpression)node;
        if (comparison.getSubType() != 2) {
            this.traceQueryCondition(false, "The comparison is not '='.", trace);
            return false;
        }
        V5DetailFilter detailFilter = (V5DetailFilter)node.getAncestorOfType(101008);
        if (detailFilter == null) {
            this.traceQueryCondition(false, "The comparison is in a detail filter.", trace);
            return false;
        }
        if (detailFilter.getBooleanPropertyValue("masterDetailDFilter") == null) {
            this.traceQueryCondition(false, "The detail filter was not created for a master detail query.", trace);
            return false;
        }
        if (!V5ExpressionCheck.isMemberExpression(node.getChild(0))) {
            this.traceQueryCondition(false, "The LHS of the '=' is already not a member expression.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The '=' is in a detail filter created by a master detail filter and the LHS is a member expression.", trace);
        return true;
    }
}

