/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ApplyComplementarityLaws
extends Transformation {
    public ApplyComplementarityLaws() {
        this.mName = "Apply Boolean Complementarity Law.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{201003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        parent.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = true;
        XQETrace trace = environment.getTrace();
        if (((V5LogicalExpression)node).getSubType() != 1) {
            status = false;
        } else if (node.getChild(1).getType() != 201003 || ((V5SimpleNode)node.getChild(1)).getSubType() != 2) {
            status = false;
        } else if (!node.getChild(0).isSameExpression(node.getChild(1).getChild(0), false)) {
            status = false;
        }
        if (status && node.getParent().getType() != 101008) {
            this.traceNodeCondition(false, "The logical expression is not a child of a detail filter.", trace);
            return false;
        }
        if (!status) {
            this.traceNodeCondition(false, "The logical expression is not of the form A AND NOT A or A OR NOT A.", trace);
        } else {
            this.traceNodeCondition(true, "The logical expression is of the form A AND NOT A or A OR NOT A.", trace);
        }
        return status;
    }
}

