/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ApplyConsensusLaws
extends Transformation {
    public ApplyConsensusLaws() {
        this.mName = "Apply Boolean Consensus Laws.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{201003};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.exchangeChildNode(node.getChild(1), node.getChild(1).detachChild(0), false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = this.isConsensus(node);
        if (!status) {
            status = this.isConsensusConjunctive(node);
        }
        if (!status) {
            this.traceNodeCondition(false, "The logical expression is not of the form(A AND B) OR (NOT A AND C) OR (B AND C) or (A OR B) AND (NOT A OR C) AND (B OR C).", trace);
        } else {
            this.traceNodeCondition(false, "The logical expression is of the form (A AND B) OR (NOT A AND C) OR (B AND C) or (A OR B) AND (NOT A OR C) AND (B OR C).", trace);
        }
        return status;
    }

    protected boolean isConsensus(IXQEQueryNode node) {
        if (!this.isOR(node)) {
            return false;
        }
        IXQEQueryNode lChild = ((V5LogicalExpression)node).getChild(0);
        IXQEQueryNode rChild = ((V5LogicalExpression)node).getChild(1);
        if (!this.isAND(lChild)) {
            return false;
        }
        if (!this.isOR(rChild)) {
            return false;
        }
        if (!this.isAND(rChild.getChild(0)) || !this.isAND(rChild.getChild(1))) {
            return false;
        }
        IXQEQueryNode notX = rChild.getChild(0).getChild(0);
        if (!this.isNOT(notX)) {
            return false;
        }
        return lChild.getChild(0).isSameExpression(notX.getChild(0), false) && lChild.getChild(1).isSameExpression(rChild.getChild(1).getChild(0), false) && rChild.getChild(0).getChild(1).isSameExpression(rChild.getChild(1).getChild(1), false);
    }

    protected boolean isConsensusConjunctive(IXQEQueryNode node) {
        if (!this.isAND(node)) {
            return false;
        }
        IXQEQueryNode lChild = ((V5LogicalExpression)node).getChild(0);
        IXQEQueryNode rChild = ((V5LogicalExpression)node).getChild(1);
        if (!this.isOR(lChild)) {
            return false;
        }
        if (!this.isAND(rChild)) {
            return false;
        }
        if (!this.isOR(rChild.getChild(0)) || !this.isOR(rChild.getChild(1))) {
            return false;
        }
        IXQEQueryNode notX = rChild.getChild(0).getChild(0);
        if (!this.isNOT(notX)) {
            return false;
        }
        return lChild.getChild(0).isSameExpression(notX.getChild(0), false) && lChild.getChild(1).isSameExpression(rChild.getChild(1).getChild(0), false) && rChild.getChild(0).getChild(1).isSameExpression(rChild.getChild(1).getChild(1), false);
    }

    private boolean isAND(IXQEQueryNode expr) {
        if (expr.getType() != 201003) {
            return false;
        }
        int subType = ((V5LogicalExpression)expr).getSubType();
        return subType == 0;
    }

    private boolean isOR(IXQEQueryNode expr) {
        if (expr.getType() != 201003) {
            return false;
        }
        int subType = ((V5LogicalExpression)expr).getSubType();
        return subType == 1;
    }

    private boolean isNOT(IXQEQueryNode expr) {
        if (expr.getType() != 201003) {
            return false;
        }
        int subType = ((V5LogicalExpression)expr).getSubType();
        return subType == 2;
    }
}

