/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundSQLQueryItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import java.util.List;

public final class AugmentV5SQLQueryItemReferenceWithDataType
extends Transformation {
    public AugmentV5SQLQueryItemReferenceWithDataType() {
        this.mName = "Augment bound V5 SQLQueryItem reference with data type information.";
        this.mPassNumbers = new int[]{22};
        this.mTypes = new int[]{201103};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundSQLQueryItemReference sqlQueryItemRef = (V5BoundSQLQueryItemReference)node;
        SQLQueryItem referencedItem = AugmentV5SQLQueryItemReferenceWithDataType.findSQLQueryItem(sqlQueryItemRef);
        sqlQueryItemRef.setDataType(referencedItem.getDataType());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5BoundSQLQueryItemReference sqlQueryItemRef = (V5BoundSQLQueryItemReference)node;
        if (sqlQueryItemRef.getDataType() != null) {
            this.traceQueryCondition(false, "Identifiers already has a data type, doesn't need to be augmented with datatype information.", trace);
            return false;
        }
        SQLQueryItem referencedItem = AugmentV5SQLQueryItemReferenceWithDataType.findSQLQueryItem(sqlQueryItemRef);
        if (referencedItem == null) {
            node.throwInternalError("Unable to find SQL query item for V5SQLQueryItemReference in AugmentV5SQLQueryItemReferenceWithDataType for node: " + node.getId());
        }
        if (referencedItem.getDataType() == null) {
            node.throwInternalError("The referenced SQL query item has no data type for V5SQLQueryItemReference in AugmentV5SQLQueryItemReferenceWithDataType for node: " + node.getId());
        }
        this.traceQueryCondition(true, "The V5SQLQueryItemReference doesn't have data type information.", trace);
        return true;
    }

    public static SQLQueryItem findSQLQueryItem(V5BoundSQLQueryItemReference sqlQueryItemRef) {
        V5Source source;
        IXQEQueryNode query = sqlQueryItemRef.getAncestorOfType(101006);
        IXQEQueryNode pp = sqlQueryItemRef.getParent().getParent();
        if (pp.getType() == 101003 && ((V5DataItem)pp).getOriginalV5DataItem() != null) {
            query = ((V5DataItem)pp).getOriginalV5DataItem().getAncestorOfType(101006);
        }
        if ((source = (V5Source)query.getFirstChildByType(101007)).getNumberChildren() > 0 && (query = source.getFirstDescendantOfTypeOrdered(101016, false)) != null && ((String)query.getPropertyValue("name")).equals(sqlQueryItemRef.getSQLQueryName())) {
            SQLQueryBlock qBlock = (SQLQueryBlock)query.getChild(0);
            List<String> nameList = qBlock.getDerivedColumnList();
            SQLQueryItemList itemList = qBlock.getQueryItemList();
            for (int i = 0; i < itemList.size(); ++i) {
                SQLQueryItem queryItem = (SQLQueryItem)itemList.get(i);
                String name = nameList != null ? nameList.get(i) : queryItem.getName();
                if (name == null || !name.equals(sqlQueryItemRef.getColumnName())) continue;
                return queryItem;
            }
        }
        return null;
    }
}

