/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.BindV5Parameter;

public class BindV5ParameterWithNoDataType
extends Transformation {
    public BindV5ParameterWithNoDataType(int[] passNumbers) {
        this.mName = "Bind V5 Literal Prompt with no datatype information to the model.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[1];
        this.mTypes[0] = 201024;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue("datatype", StringType.DEFAULTSTRINGTYPE);
        BindV5Parameter.bindV5ParameterToBoundParameter(node, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = false;
        XQETrace trace = environment.getTrace();
        V5Parameter prompt = (V5Parameter)node;
        IDataType dataType = (IDataType)prompt.getPropertyValue("datatype");
        if (dataType == null) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "The V5Parameter node has no datatype.", trace);
        } else {
            this.traceNodeCondition(status, "The V5Parameter node has datatype information.", trace);
        }
        return status;
    }
}

