/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5InExpression;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.binding.BindV5MultiPartIdentifierToModel;
import com.cognos.xqe.transformation.v5tocogmdx.DisableDMRCubeReuseOnMDXQuery;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConvertDMRSlicerToDetailFilter
extends Transformation {
    private static final String PROP_STRING_CONVERTDMRSLICERTODETAILFILTER_APPLIED = "ConvertDMRSlicerToDetailFilterApplied";

    public ConvertDMRSlicerToDetailFilter() {
        this.mName = "ConvertDMRSlicerToDetailFilter.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{101010};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        StringBuilder reason;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        boolean isCubeReuseEnabled = !DisableDMRCubeReuseOnMDXQuery.isDMRCubeReuseDisabled(query, environment, reason = new StringBuilder());
        Set<IHierarchy> refHierarchies = this.getReferencedHierarchies(query);
        HashSet<IHierarchy> completeTupleHierarchies = new HashSet<IHierarchy>();
        for (IXQEQueryNode completeTuple : query.getDescendantsOfType(201056, false)) {
            for (IXQEQueryNode childNode : completeTuple.getChildren()) {
                V5SimpleNode currentV5Node = null;
                currentV5Node = childNode.getType() == 101003 ? (V5SimpleNode)childNode.getChild(0) : (V5SimpleNode)childNode;
                if (currentV5Node.getType() == 201060) {
                    currentV5Node = ((V5BoundDataItemReference)currentV5Node).getReferencedExpression();
                }
                if (currentV5Node.getType() != 201059) continue;
                completeTupleHierarchies.add(currentV5Node.getHierarchyInfo().getProjectedHierarchy(0));
            }
        }
        for (IXQEQueryNode child : node.getChildren()) {
            IHierarchy hierarchy = null;
            V5SetFunction setExpr = (V5SetFunction)nodeFactory.createNode(201101);
            List<IXQEQueryNode> memberRefs = child.getDescendantsOfTypeOrdered(201117, false);
            hierarchy = ((V5BoundMemberUniqueName)memberRefs.get(0)).getHierarchy();
            if (!this.couldCauseDoubleCounting(memberRefs) && refHierarchies != null && !refHierarchies.contains(hierarchy) && isCubeReuseEnabled || completeTupleHierarchies.contains(hierarchy) || this.processTheSlicerInMDX(environment, query, child)) continue;
            for (IXQEQueryNode memberRef : memberRefs) {
                setExpr.addChild(memberRef.detach());
            }
            if (hierarchy == null) continue;
            V5BoundModelIdentifier hierExpr = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            hierExpr.setMetadata(hierarchy);
            hierExpr.setIdentifier(hierarchy.getV5UniqueName());
            if (hierarchy instanceof HierarchyWrapper) {
                hierExpr.setPropertyValue("isMetadataWrapped", Boolean.TRUE);
            }
            V5InExpression inExpr = (V5InExpression)nodeFactory.createNode(201011);
            inExpr.addChild(hierExpr);
            inExpr.addChild(setExpr);
            V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            String applyTo = (String)node.getPropertyValue("applyToDSQS");
            if (applyTo != null) {
                detailFilter.setPropertyValue("applyToDSQS", applyTo);
            }
            detailFilter.setPostAutoAggregation(false);
            detailFilter.setPropertyValue("dmrSlicer", Boolean.TRUE);
            detailFilter.setPropertyValue("dmrSlicerSet", nodeFactory.deepCopyNode(setExpr));
            detailFilter.addChild(inExpr);
            query.addChild(detailFilter);
            child.detach();
        }
        if (node.getNumberChildren() == 0) {
            node.detach();
        } else {
            node.setPropertyValue(PROP_STRING_CONVERTDMRSLICERTODETAILFILTER_APPLIED, true);
        }
    }

    private Set<IHierarchy> getReferencedHierarchies(V5Query query) {
        IXQEQueryNode[] v5Slicers;
        IXQEQueryNode[] v5DetailFilters;
        IXQEQueryNode[] v5SummaryFilterNodes;
        List<IXQEQueryNode> modelItems = query.getV5Selection().getDescendantsOfCategory(201029, false);
        for (IXQEQueryNode sf : v5SummaryFilterNodes = query.getV5SummaryFilters()) {
            modelItems.addAll(sf.getDescendantsOfCategory(201029, false));
        }
        for (IXQEQueryNode df : v5DetailFilters = query.getV5DetailFilters()) {
            modelItems.addAll(df.getDescendantsOfCategory(201029, false));
        }
        for (IXQEQueryNode s : v5Slicers = query.getV5Slicers()) {
            modelItems.addAll(s.getDescendantsOfCategory(201029, false));
        }
        HashSet<IHierarchy> refHierarchies = new HashSet<IHierarchy>();
        for (IXQEQueryNode aModelItem : modelItems) {
            IMetadata metadataObj = ((V5BoundToMetadata)aModelItem).getMetadata();
            if (metadataObj == null) continue;
            IHierarchy hierarchy = MetadataUtil.getHierarchy(metadataObj);
            if (hierarchy != null) {
                refHierarchies.add(hierarchy);
                continue;
            }
            return null;
        }
        return refHierarchies;
    }

    private Set<IHierarchy> getProjectedHierarchies(V5Query query) {
        IXQEQueryNode[] v5DetailFilters;
        IXQEQueryNode[] v5SummaryFilterNodes;
        List<IXQEQueryNode> modelItems = query.getV5Selection().getDescendantsOfCategory(201029, false);
        for (IXQEQueryNode sf : v5SummaryFilterNodes = query.getV5SummaryFilters()) {
            modelItems.addAll(sf.getDescendantsOfCategory(201029, false));
        }
        for (IXQEQueryNode df : v5DetailFilters = query.getV5DetailFilters()) {
            modelItems.addAll(df.getDescendantsOfCategory(201029, false));
        }
        HashSet<IHierarchy> refHierarchies = new HashSet<IHierarchy>();
        for (IXQEQueryNode aModelItem : modelItems) {
            IHierarchy hierarchy;
            IMetadata metadataObj = ((V5BoundToMetadata)aModelItem).getMetadata();
            if (metadataObj == null || (hierarchy = MetadataUtil.getHierarchy(metadataObj)) == null) continue;
            refHierarchies.add(hierarchy);
        }
        return refHierarchies;
    }

    private boolean couldCauseDoubleCounting(List<IXQEQueryNode> members) {
        ILevel level = null;
        for (int i = 0; i < members.size(); ++i) {
            V5BoundMemberUniqueName aMember = (V5BoundMemberUniqueName)members.get(i);
            ILevel memberLevel = aMember.getLevel();
            if (level == null) {
                level = memberLevel;
                continue;
            }
            if (!level.equals(memberLevel)) {
                return true;
            }
            for (int j = i + 1; j < members.size(); ++j) {
                if (!aMember.isSameExpression(members.get(j), false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_STRING_CONVERTDMRSLICERTODETAILFILTER_APPLIED) != null) {
            this.traceNodeCondition(false, this.mName + " has been applied to DMR slicer.", environment.getTrace());
            return false;
        }
        V5Query query = DMRUtilities.findQuery(node);
        if (!query.isDMR()) {
            this.traceNodeCondition(false, "Query is not DMR.", environment.getTrace());
            return false;
        }
        String suppress = (String)query.getPropertyValue(V5Query.QueryHint.SUPPRESS.getPropertyName());
        if (suppress == null) {
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(XQEMessages.getMessage(XQEMessageKeys.WRN_DMRSlicerNoSuppressHint, XQEMessages.getCurrProductLocale()));
        }
        for (IXQEQueryNode child : node.getChildren()) {
            IXQEQueryNode[] memberRefs = child.getDescendantsOfType(201117, false);
            if (memberRefs.length == 0) {
                this.traceNodeCondition(false, "The slicer memberset has no data item or MUN.", environment.getTrace());
                return false;
            }
            for (IXQEQueryNode memberRef : memberRefs) {
                if (memberRef.getParent() != child && memberRef.getParent().getType() != 201101 && memberRef.getParent().getType() != 101003) {
                    this.traceNodeCondition(false, "This is not a simple set of members.", environment.getTrace());
                    return false;
                }
                IHierarchy hier = ((V5BoundMemberUniqueName)memberRef).getHierarchy();
                if (!hier.getDimension().isMeasuresDimension()) continue;
                this.traceNodeCondition(false, "There is measure in the slicer.", environment.getTrace());
                return false;
            }
            int[] types = new int[]{101003, 201101};
            for (IXQEQueryNode memberRef : memberRefs = child.getDescendantsOfTypes(types, false)) {
                if (memberRef.getParent() == child || memberRef.getParent().getType() == 201101 || memberRef.getParent().getType() == 101003) continue;
                this.traceNodeCondition(false, "This is a complex slicer memberset.", environment.getTrace());
                return false;
            }
        }
        this.traceNodeCondition(true, "V5Slicer in DMR query will be converted to a V5DetailFilter.", trace);
        return true;
    }

    private boolean slicerRefersToProjectedHierarchy(V5Query v5Query, IXQEQueryNode slicerMemebeSet) {
        Set<IHierarchy> projectedHierarchies = this.getProjectedHierarchies(v5Query);
        List<IXQEQueryNode> memberRefs = slicerMemebeSet.getDescendantsOfTypeOrdered(201117, false);
        IHierarchy hierarchy = ((V5BoundMemberUniqueName)memberRefs.get(0)).getHierarchy();
        return hierarchy != null && projectedHierarchies != null && projectedHierarchies.contains(hierarchy);
    }

    private boolean processTheSlicerInMDX(PlanningEnvironment environment, V5Query v5Query, IXQEQueryNode v5SlicerMemberSet) {
        IXQEQueryNode[] dataItems;
        if (this.slicerRefersToProjectedHierarchy(v5Query, v5SlicerMemberSet)) {
            return false;
        }
        V5Selection selection = v5Query.getV5Selection();
        for (IXQEQueryNode dataItem : dataItems = selection.getChildrenOfType(101003)) {
            IXQEQueryNode[] allV5BoundNodes;
            V5DataItem di = (V5DataItem)dataItem;
            if (!di.isAggregate()) continue;
            IXQEQueryNode expression = di.getExpression(true);
            for (IXQEQueryNode v5Node : allV5BoundNodes = expression.getDescendantsOfType(201116, true)) {
                IXQEQueryNode[] allV5NodesToBind;
                V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)v5Node;
                if (!(v5BoundID.getMetadata() instanceof MeasureWrapper)) continue;
                IMeasure measure = ((MeasureWrapper)v5BoundID.getMetadata()).getWrapped();
                String measureExpression = measure.getExpression();
                IXQEQueryNode binaryExpression = RQPUtilities.createV5ValueExpressionMetadata(measureExpression, environment, null, measure);
                for (IXQEQueryNode nodeToBind : allV5NodesToBind = binaryExpression.getDescendantsOfType(201030, true)) {
                    V5BoundModelIdentifier boundNode = BindV5MultiPartIdentifierToModel.bindV5MultiPartIdentifierToModel(environment, (V5MultiPartIdentifier)nodeToBind);
                    IMetadata boundNodeMetadata = boundNode.getMetadata();
                    if (boundNodeMetadata instanceof IQueryItem) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

