/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.ast.v5Exp.V5GenericSetFunction;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ConvertGenericToGenericSet
extends Transformation {
    public ConvertGenericToGenericSet() {
        this.mName = "Convert V5GenericFunction to V5GenericSetFunction.";
        this.mPassNumbers = new int[]{28};
        this.mTypes = new int[]{201042};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5GenericSetFunction v5Generic = (V5GenericSetFunction)nodeFactory.createNode(201140);
        node.getParent().exchangeChildNode(node, v5Generic, true);
        v5Generic.setNativeName(((V5GenericFunction)node).getName());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "Node does not project any children.", trace);
            return false;
        }
        IFunction function = FunctionManager.getFunction(((V5GenericFunction)node).getName());
        if (function != null) {
            this.traceNodeCondition(false, "Function is defined in the function manager.", trace);
            return false;
        }
        StringBuilder sb = new StringBuilder("udf.set.");
        sb.append(((V5GenericFunction)node).getName().toLowerCase());
        sb.append("[");
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("member");
        }
        sb.append("]");
        IDataSourceCapabilities capabilities = environment.getCapabilities(null);
        if (capabilities == null) {
            this.traceNodeCondition(false, "Unable to find the provider capabilities.", trace);
            return false;
        }
        if (capabilities.getStringValue(sb.toString(), "error").equals("error")) {
            this.traceNodeCondition(false, "Function not found in the provider capabilities.", trace);
            return false;
        }
        this.traceNodeCondition(false, "OLAP set function found in the provider capabilities.", trace);
        return true;
    }
}

