/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5BetweenExpression;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5InRangeExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralNull;
import com.cognos.xqe.ast.v5Exp.V5LiteralRange;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5StringFunction;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.ReplaceV5BoundParameterWithParameterValue;
import com.cognos.xqe.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;

public final class ConvertV5InRangeToCondition
extends Transformation {
    public ConvertV5InRangeToCondition(int[] passNumbers) {
        this.mName = "Convert V5InRangeExpression To Conditional Expression.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201012};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        boolean inRangeTruncated = "in_range_truncated".equals(((V5InRangeExpression)node).getNativeName().toLowerCase());
        if (inRangeTruncated && !v5Query.isTabular()) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_V5PlanFailed, node.getNodeTypeName());
        }
        IXQEQueryNode value = node.getChild(0);
        IXQEQueryNode result = null;
        IXQEQueryNode condition = null;
        IXQEQueryNode inExp = null;
        IXQEQueryNode notInExp = null;
        int[] types = new int[]{201026};
        boolean enableNulls = true;
        if (enableNulls) {
            types = new int[]{201026, 201023};
        }
        ArrayList<IXQEQueryNode> v5LiteralValues = new ArrayList<IXQEQueryNode>();
        for (int i = 1; i < node.getNumberChildren(); ++i) {
            if (!ArrayUtil.contains(types, node.getChild(i).getNodeType())) continue;
            v5LiteralValues.add(node.getChild(i));
        }
        ArrayList<IXQEQueryNode> inclusiveLiterals = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> exclusiveLiterals = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < v5LiteralValues.size(); ++i) {
            IXQEQueryNode lit = (IXQEQueryNode)v5LiteralValues.get(i);
            boolean inc = true;
            inc = lit instanceof V5LiteralValue ? ((V5LiteralValue)lit).getInclusive() : ((V5LiteralNull)lit).getInclusive();
            if (inc) {
                inclusiveLiterals.add(lit);
                continue;
            }
            exclusiveLiterals.add(lit);
        }
        boolean newWayForInvert = ReplaceV5BoundParameterWithParameterValue.useNewWayForInvert();
        if (newWayForInvert) {
            result = inclusiveLiterals.size() > 0 ? this.createInExp(factory, value, inclusiveLiterals) : this.createInExp(factory, value, exclusiveLiterals);
        } else {
            inExp = this.createInExp(factory, value, inclusiveLiterals);
            notInExp = this.createNotInExp(factory, value, exclusiveLiterals);
            result = this.combineConditions(factory, inExp, notInExp);
        }
        IXQEQueryNode[] v5LiteralRangeNodes = node.getChildrenOfTypesOrdered(new int[]{201022});
        ArrayList<IXQEQueryNode> simpleLiterals = new ArrayList<IXQEQueryNode>();
        ArrayList<V5LiteralRange> nonSimpleLiterals = new ArrayList<V5LiteralRange>();
        for (IXQEQueryNode lit : v5LiteralRangeNodes) {
            V5LiteralRange litRange = (V5LiteralRange)lit;
            if (litRange.getSubType() == 3) {
                simpleLiterals.add(litRange.detach().getChild(0));
                continue;
            }
            nonSimpleLiterals.add(litRange);
        }
        inExp = this.createInExp(factory, value, simpleLiterals);
        result = result == null ? inExp : this.combineConditions(factory, result, inExp);
        for (int i = 0; i < nonSimpleLiterals.size(); ++i) {
            V5LiteralRange rangeValue = (V5LiteralRange)((IXQEQueryNode)nonSimpleLiterals.get(i)).detach();
            switch (rangeValue.getSubType()) {
                case 2: {
                    condition = this.createBoundRangeExpression(rangeValue, value, factory, inRangeTruncated);
                    break;
                }
                case 1: {
                    condition = this.createUnboundedEndRangeExpression(rangeValue, value, factory);
                    break;
                }
                case 0: {
                    condition = this.createUnboundedStartRangeExpression(rangeValue, value, factory, inRangeTruncated);
                    break;
                }
                default: {
                    node.throwInternalError("Invalid SubType for node.");
                }
            }
            if (!newWayForInvert && !rangeValue.getInclusive()) {
                V5LogicalExpression notExpression = (V5LogicalExpression)factory.createNode(201003);
                notExpression.setSubType(2);
                notExpression.addChild(condition);
                condition = notExpression;
            }
            result = result == null ? condition : this.combineConditions(factory, result, condition);
        }
        node.getParent().exchangeChildNode(node, result);
    }

    private IXQEQueryNode createInExp(IXQENodeFactory factory, IXQEQueryNode left, List<IXQEQueryNode> values) {
        if (0 == values.size()) {
            return null;
        }
        if (1 == values.size()) {
            return this.createSimpleExpression((V5LiteralValue)values.get(0), left, factory);
        }
        IXQEQueryNode inExp = factory.createNode(201011);
        inExp.addChild(factory.deepCopyNode(left));
        for (IXQEQueryNode value : values) {
            value.move(inExp);
        }
        return inExp;
    }

    private IXQEQueryNode createNotInExp(IXQENodeFactory factory, IXQEQueryNode left, List<IXQEQueryNode> values) {
        if (0 == values.size()) {
            return null;
        }
        if (1 == values.size()) {
            return this.createSimpleExpression((V5LiteralValue)values.get(0), left, factory);
        }
        IXQEQueryNode inExp = this.createInExp(factory, left, values);
        V5LogicalExpression notExp = (V5LogicalExpression)factory.createNode(201003);
        notExp.setSubType(2);
        notExp.addChild(inExp);
        return notExp;
    }

    private IXQEQueryNode combineConditions(IXQENodeFactory factory, IXQEQueryNode condition1, IXQEQueryNode condition2) {
        if (condition1 == null && condition2 == null) {
            return null;
        }
        if (condition1 == null) {
            return condition2;
        }
        if (condition2 == null) {
            return condition1;
        }
        V5LogicalExpression orExpression = (V5LogicalExpression)factory.createNode(201003);
        orExpression.setSubType(1);
        orExpression.addChild(condition1);
        orExpression.addChild(condition2);
        return orExpression;
    }

    IXQEQueryNode createSimpleExpression(V5LiteralValue simpleValue, IXQEQueryNode value, IXQENodeFactory factory) {
        int expression = 2;
        if (!simpleValue.getInclusive()) {
            expression = 3;
        }
        V5ComparisonExpression equalsComparison = (V5ComparisonExpression)factory.createNode(201013);
        equalsComparison.setSubType(expression);
        equalsComparison.addChild(factory.deepCopyNode(value));
        equalsComparison.addChild(simpleValue);
        return equalsComparison;
    }

    IXQEQueryNode createBoundRangeExpression(V5LiteralRange range, IXQEQueryNode value, IXQENodeFactory factory, boolean inRangeTruncated) {
        AbstractV5BooleanExpression condition = null;
        V5LiteralValue startBound = (V5LiteralValue)range.getChild(0);
        V5LiteralValue endBound = (V5LiteralValue)range.getChild(1);
        int startBoundExpression = 4;
        int endBoundExpression = 1;
        if (!startBound.getInclusive()) {
            startBoundExpression = 5;
        }
        if (!endBound.getInclusive()) {
            endBoundExpression = 0;
        }
        if (startBoundExpression == 4 && endBoundExpression == 1) {
            if (this.mustAdjustInRangeTruncated(inRangeTruncated, endBound.getDataType())) {
                IXQEQueryNode endRange = this.createUnboundedEndRangeExpression(range, value, factory);
                IXQEQueryNode startRange = this.createUnboundedStartRangeExpression(range, value, factory, inRangeTruncated);
                condition = this.createAndExpression(factory, endRange, startRange);
                range.detachChildren();
            } else {
                V5BetweenExpression betweenComparison = (V5BetweenExpression)factory.createNode(201008);
                betweenComparison.addChild(factory.deepCopyNode(value));
                betweenComparison.addChild(range.detachChild(0));
                betweenComparison.addChild(range.detachChild(0));
                condition = betweenComparison;
            }
        } else {
            V5LogicalExpression andExpression;
            V5ComparisonExpression startBoundComparison = (V5ComparisonExpression)factory.createNode(201013);
            startBoundComparison.setSubType(startBoundExpression);
            startBoundComparison.addChild(factory.deepCopyNode(value));
            startBoundComparison.addChild(range.detachChild(0));
            IXQEQueryNode clonedValue = factory.deepCopyNode(value);
            if (this.mustAdjustInRangeTruncated(inRangeTruncated, endBound.getDataType())) {
                int substringSize = endBound.getValue().toString().length();
                clonedValue = this.createSubstringExpression(factory, clonedValue, 1, substringSize);
            }
            V5ComparisonExpression endBoundComparison = (V5ComparisonExpression)factory.createNode(201013);
            endBoundComparison.setSubType(endBoundExpression);
            endBoundComparison.addChild(clonedValue);
            endBoundComparison.addChild(range.detachChild(0));
            condition = andExpression = this.createAndExpression(factory, startBoundComparison, endBoundComparison);
        }
        return condition;
    }

    IXQEQueryNode createUnboundedStartRangeExpression(V5LiteralRange range, IXQEQueryNode value, IXQENodeFactory factory, boolean inRangeTruncated) {
        V5ComparisonExpression condition = null;
        V5LiteralValue endBound = (V5LiteralValue)range.getChild(0);
        int endBoundExpression = 1;
        IXQEQueryNode clonedValue = factory.deepCopyNode(value);
        if (!endBound.getInclusive()) {
            endBoundExpression = 0;
        }
        if (this.mustAdjustInRangeTruncated(inRangeTruncated, endBound.getDataType())) {
            int substringSize = endBound.getValue().toString().length();
            clonedValue = this.createSubstringExpression(factory, clonedValue, 1, substringSize);
        }
        V5ComparisonExpression endComparison = (V5ComparisonExpression)factory.createNode(201013);
        endComparison.setSubType(endBoundExpression);
        endComparison.addChild(clonedValue);
        endComparison.addChild(range.detachChild(0));
        condition = endComparison;
        return condition;
    }

    IXQEQueryNode createUnboundedEndRangeExpression(V5LiteralRange range, IXQEQueryNode value, IXQENodeFactory factory) {
        V5ComparisonExpression condition = null;
        V5LiteralValue startBound = (V5LiteralValue)range.getChild(0);
        int startBoundExpression = 4;
        if (!startBound.getInclusive()) {
            startBoundExpression = 5;
        }
        V5ComparisonExpression startComparison = (V5ComparisonExpression)factory.createNode(201013);
        startComparison.setSubType(startBoundExpression);
        startComparison.addChild(factory.deepCopyNode(value));
        startComparison.addChild(range.detachChild(0));
        condition = startComparison;
        return condition;
    }

    private V5StringFunction createSubstringExpression(IXQENodeFactory factory, IXQEQueryNode value, int fromPos, int forSize) {
        V5StringFunction substringNode = (V5StringFunction)factory.createNode(201041);
        substringNode.setSubType(2);
        value.insertParent(substringNode);
        V5LiteralValue fromPosNode = (V5LiteralValue)factory.createNode(201026);
        fromPosNode.setDataType(IntegerType.INTEGERTYPE);
        fromPosNode.setValue(Integer.toString(fromPos));
        V5LiteralValue forSizeNode = (V5LiteralValue)factory.createNode(201026);
        forSizeNode.setDataType(IntegerType.INTEGERTYPE);
        forSizeNode.setValue(Integer.toString(forSize));
        substringNode.addChild(fromPosNode);
        substringNode.addChild(forSizeNode);
        return substringNode;
    }

    private V5LogicalExpression createAndExpression(IXQENodeFactory factory, IXQEQueryNode startRange, IXQEQueryNode endRange) {
        V5LogicalExpression andNode = (V5LogicalExpression)factory.createNode(201003);
        andNode.setSubType(0);
        andNode.addChild(startRange);
        andNode.addChild(endRange);
        return andNode;
    }

    private boolean mustAdjustInRangeTruncated(boolean inRangeTruncated, IDataType dataType) {
        if (inRangeTruncated) {
            if (dataType.isTextType()) {
                return true;
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidDataTypeForInRangeTruncated);
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildrenOfTypes(new int[]{201026, 201022}) == 0) {
            this.traceNodeCondition(false, "There are no V5LiteralRange children for the node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The node is ready to process.", trace);
        return true;
    }
}

