/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5MasterDetailLink;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameParser;

public class CreateMasterDetailLinkFilter
extends Transformation {
    private static final String CLOSE_BRACKET = "]";
    private static final String CLOSE_BRACKET_PERIOD = "].";
    private static final String OPEN_BRACKET = "[";

    public CreateMasterDetailLinkFilter() {
        this.mName = "Create master-detail link filter";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{101059};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
        V5MasterDetailLink linkNode = (V5MasterDetailLink)node;
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getParent();
        String linkName = mdProvider.addLink(qrd, linkNode, querySet);
        MasterDetailLink link = mdProvider.getLink(linkName);
        String detailQueryName = link.getDetailQueryName();
        V5Query detailQuery = querySet.getV5Query(detailQueryName);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5DetailFilter filterNode = (V5DetailFilter)nodeFactory.createV5Node("detailFilter");
        filterNode.setPropertyValue("qrdName", link.getDetailQrdName());
        detailQuery.addChild(filterNode);
        StringBuilder expBuf = new StringBuilder();
        String escapedName = UniqueNameParser.escapeSquareBrackets(link.getDetailRefDataItem());
        expBuf.append(OPEN_BRACKET).append(escapedName).append("] = ?").append(linkName).append("?");
        IXQEQueryNode expNode = V5ExpressionProcessor.process(expBuf.toString(), environment, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale(), filterNode);
        filterNode.setPropertyValue("use", "required");
        filterNode.setPropertyValue("masterDetailDFilter", Boolean.TRUE);
        filterNode.setPropertyValue("masterDetailSectionedXtab", link.isSectionedCrosstab());
        filterNode.addChild(expNode);
        this.setMasterDetailLinkDescription(link, filterNode);
        expNode.setPropertyValue("masterDetailLinkName", linkName);
        linkNode.setPropertyValue("detailMDFilterCreated", true);
    }

    private void setMasterDetailLinkDescription(MasterDetailLink link, V5DetailFilter filterNode) {
        StringBuilder sb = new StringBuilder();
        sb.append(OPEN_BRACKET);
        sb.append(link.getMasterQueryNameOrig());
        sb.append(CLOSE_BRACKET_PERIOD);
        sb.append(OPEN_BRACKET);
        sb.append(link.getMasterRefDataItem());
        sb.append(CLOSE_BRACKET);
        sb.append("<=>");
        sb.append(OPEN_BRACKET);
        sb.append(link.getDetailQueryNameOrig());
        sb.append(CLOSE_BRACKET_PERIOD);
        sb.append(OPEN_BRACKET);
        sb.append(link.getDetailRefDataItem());
        sb.append(CLOSE_BRACKET);
        filterNode.setMasterDetailLinkDescription(sb.toString());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getBooleanPropertyValue("detailMDFilterCreated") != null;
        if (status) {
            this.traceQueryCondition(false, "The master-detail link already contains the detail filter.", trace);
            return false;
        }
        MasterDetailLink link = ((V5MasterDetailLink)node).getMDProviderLink();
        if (link == null) {
            this.traceQueryCondition(false, "The link has not been processed yet.", trace);
            return false;
        }
        if (link.isParameterLink() && link.getParameterName().equals(link.getDetailRefDataItem()) || ((RequestEnvironment)environment.getRequestEnvironment()).isGetParametersRequest()) {
            this.traceQueryCondition(false, "The master-detail filter is not required.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The detail query requires a new detail filter with a prompt.", trace);
        return true;
    }
}

