/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5SlicerMemberSet;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import java.util.Set;

public class CreateV5QuerySetForShowAll
extends Transformation {
    private static final String FOR_SHOW_ALL_QRD = "ForShowAll_QRD";
    public static final String FOR_SHOW_ALL = "ForShowAll";

    public CreateV5QuerySetForShowAll() {
        this.mName = "Create the V5QuerySet for the node V5ShowAllResultSet.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] edgeChildren;
        IXQEQueryNode[] slicers;
        IXQEQueryNode[] datailFilters;
        IXQEQueryNode[] dataItems;
        V5DataItem v5DataItem = (V5DataItem)node;
        V5QuerySet v5QuerySet = (V5QuerySet)v5DataItem.getAncestorOfType(101002);
        PlanningEnvironment subQueryEnvironment = V5SubQueryBuilder.createPlanningEnvironmentWithoutTracing((ExecutionEnvironment)environment.getExecutionEnvironment(), environment);
        XQENodeFactory nodeFactory = subQueryEnvironment.getNodeFactory();
        V5QuerySet subQuerySet = (V5QuerySet)nodeFactory.deepCopyNode(v5QuerySet);
        subQuerySet.removeProperty("unreferencedQRDsRemoved");
        subQuerySet.removeProperty("unreferencedQueriesRemoved");
        V5Source subV5Source = (V5Source)subQuerySet.getFirstDescendantOfTypeOrdered(101007, false);
        Set<String> keySet = subQuerySet.getProperties().keySet();
        for (String currKey : keySet) {
            if ("modelPath".equals(currKey)) {
                subV5Source.setModel((String)subQuerySet.getPropertyValue(currKey));
            } else if ("modelType".equals(currKey)) {
                subV5Source.setStringPropertyValue("modelType", (String)subQuerySet.getPropertyValue("modelType"));
            }
            subQuerySet.removeProperty(currKey);
        }
        V5Query subQuery = (V5Query)subQuerySet.getFirstChildByType(101006);
        subQuery.setStringPropertyValue("name", FOR_SHOW_ALL);
        V5QueryResultDefinition subQRD = (V5QueryResultDefinition)subQuerySet.getFirstChildByType(101055);
        subQRD.setStringPropertyValue("name", subQuery.getV5QueryName() + FOR_SHOW_ALL_QRD);
        subQRD.setRefQueryProperty(subQuery.getV5QueryName());
        for (IXQEQueryNode dataItem : dataItems = subQuery.getDescendantsOfType(101003, false)) {
            if (((V5DataItem)dataItem).getShowAllProperty() == null) continue;
            ((V5DataItem)dataItem).setShowAllProperty(false);
            ((V5DataItem)dataItem).setContextProperty(null);
            break;
        }
        String dataItemName = v5DataItem.getNameProperty();
        for (IXQEQueryNode datailFilter : datailFilters = subQuery.getDescendantsOfType(101008, false)) {
            String stringFilterExpr = ((V5DetailFilter)datailFilter).getOriginalExpression();
            if (null == stringFilterExpr || stringFilterExpr.isEmpty()) {
                datailFilter.detach();
                continue;
            }
            if (stringFilterExpr.contains(dataItemName)) continue;
            datailFilter.detach();
        }
        for (IXQEQueryNode slicer : slicers = subQuery.getDescendantsOfType(101010, false)) {
            IXQEQueryNode[] slicerMemberSets;
            IXQEQueryNode[] iXQEQueryNodeArray = slicerMemberSets = slicer.getDescendantsOfType(101014, false);
            int n = iXQEQueryNodeArray.length;
            for (int i = 0; i < n; ++i) {
                IXQEQueryNode slicerMemberSet = iXQEQueryNodeArray[i];
                String slicerMemberSetExpr = ((V5SlicerMemberSet)slicerMemberSet).getExpression();
                if (null == slicerMemberSetExpr || slicerMemberSetExpr.isEmpty()) {
                    slicerMemberSet.detach();
                    continue;
                }
                if (slicerMemberSetExpr.contains(dataItemName)) continue;
                slicerMemberSet.detach();
            }
            if (slicer.getNumberChildren() != 0) continue;
            slicer.detach();
        }
        V5Edge v5Edge = (V5Edge)subQRD.getFirstChildByType(101049);
        IXQEQueryNode v5EdgeSuppression = v5Edge.getFirstChildByType(101066);
        if (v5EdgeSuppression != null) {
            v5EdgeSuppression.detach();
        }
        IXQEQueryNode[] valueSets = v5Edge.getDescendantsOfType(101057, false);
        V5EdgeGroup targetGroup = null;
        for (IXQEQueryNode valueSet : valueSets) {
            V5ValueSet currV5ValueSet = (V5ValueSet)valueSet;
            if (currV5ValueSet.getRefDataItemProperty() != null && currV5ValueSet.getRefDataItemProperty().equals(v5DataItem.getNameProperty())) {
                IXQEQueryNode[] targetGroupChildren;
                targetGroup = (V5EdgeGroup)currV5ValueSet.getParent();
                for (IXQEQueryNode currChild : targetGroupChildren = targetGroup.getChildren()) {
                    if (currChild == currV5ValueSet) continue;
                    currChild.detach();
                }
            } else {
                IXQEQueryNode[] targetGroupChildren;
                IXQEQueryNode[] groupBodyChildren;
                IXQEQueryNode[] valueSetChildren;
                if (currV5ValueSet.getRefDataItemProperty() != null) continue;
                for (IXQEQueryNode currChild : valueSetChildren = currV5ValueSet.getChildren()) {
                    if (currChild.getType() == 101051) continue;
                    if (currChild.getType() == 101056) {
                        if (((V5SortItem)currChild).getRefDataItem().equals(v5DataItem.getNameProperty())) continue;
                        currChild.detach();
                        continue;
                    }
                    currChild.detach();
                }
                V5GroupBody v5GroupBody = (V5GroupBody)currV5ValueSet.getChild(0);
                for (IXQEQueryNode currChild : groupBodyChildren = v5GroupBody.getChildren()) {
                    if (currChild.getType() != 101015) {
                        currChild.detach();
                        continue;
                    }
                    if (!((V5DataItemRef)currChild).getDataItemRefProperty().equals(v5DataItem.getNameProperty())) {
                        currChild.detach();
                        continue;
                    }
                    targetGroup = (V5EdgeGroup)currV5ValueSet.getParent();
                }
                if (targetGroup == null) continue;
                for (IXQEQueryNode currChild : targetGroupChildren = targetGroup.getChildren()) {
                    if (currChild == currV5ValueSet) continue;
                    currChild.detach();
                }
            }
            break;
        }
        for (IXQEQueryNode currChild : edgeChildren = v5Edge.getChildren()) {
            if (currChild == targetGroup) continue;
            currChild.detach();
        }
        V5SubQueryBuilder.registerTreeInEnvironment(subQueryEnvironment, subQuerySet);
        subQuerySet.addToIndex();
        v5DataItem.setShowAllSubQuerySet(subQuerySet);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem v5DataItem = (V5DataItem)node;
        if (!Boolean.TRUE.equals(v5DataItem.getShowAllProperty())) {
            this.traceNodeCondition(false, "The data item has not set the showall flag.", trace);
            return false;
        }
        if (v5DataItem.getShowAllSubQuerySet() != null) {
            this.traceNodeCondition(false, "The data item has a showall V5QuerySet already.", trace);
            return false;
        }
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (v5QuerySet == null) {
            this.traceNodeCondition(false, "No V5QuerySet node is found.", trace);
            return false;
        }
        if (!v5QuerySet.getUnreferencedQRDsRemoved() || !v5QuerySet.getUnreferencedQueriesRemoved()) {
            this.traceNodeCondition(false, "Wait until unrefrenced queries and qrds are removed.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Can create the V5ShowAll node.", trace);
        return true;
    }
}

