/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class DetectFilterJoinOptimization
extends Transformation {
    public DetectFilterJoinOptimization(int passNumber) {
        this.mName = "Detect Filter Join Optimization";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{101019};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode querySetNode = node.getAncestorOfType(101002);
        V5QuerySet querySet = (V5QuerySet)querySetNode;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        querySet.setPropertyValue("initialQuerySet", nodeFactory.deepCopyNode(querySet));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5JoinOperation v5JoinOperation = (V5JoinOperation)node;
        IRelationship.JoinFilterType jft = (IRelationship.JoinFilterType)((Object)v5JoinOperation.getPropertyValue("joinFilterType"));
        if (jft == null || jft == IRelationship.JoinFilterType.FILTER_TYPE_NONE) {
            this.traceNodeCondition(false, "Not applicable, no join filter type defined.", trace);
            return false;
        }
        IXQEQueryNode querySetNode = node.getAncestorOfType(101002);
        V5QuerySet querySet = (V5QuerySet)querySetNode;
        if (querySet.getPropertyValue("initialQuerySet") != null) {
            this.traceNodeCondition(false, "Initial querySet for JoinFilterType=table already saved.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Passes: must save initial querySet for JoinFilterType.", trace);
        return true;
    }
}

