/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.source.ReportSource;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.report.FinalizeReportNode;
import com.cognos.xqe.transformation.v5.ReportSpec;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqemoser.ReportService;
import com.cognos.xqemoser.ReportServiceResponse;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class InjectReportQueries
extends Transformation {
    public static final String INJECT_FOR_REPORT = "injectForReport";

    public InjectReportQueries(int passNumber) {
        this.mName = "Inject Report Queries";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{101002};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5QuerySet querySet = (V5QuerySet)node;
        String modelType = querySet.getModelType();
        if (!"report".equals(modelType)) {
            this.traceNodeCondition(false, "Not applicable, modelType is not set to report.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Passes: must inject a report's queries into this V5QuerySet.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Locale reportLC;
        V5QuerySet querySet = (V5QuerySet)node;
        String modelPath = querySet.getModelPath();
        Boolean hHasMultiParts = null;
        IXQEQueryNode[] multiParts = querySet.getDescendantsOfType(201030, false);
        if (multiParts.length > 0) {
            hHasMultiParts = Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(hHasMultiParts)) {
            querySet.setPropertyValue(INJECT_FOR_REPORT, hHasMultiParts);
        }
        IXQEQueryNode[] orgQueries = querySet.getChildrenOfType(101006);
        IXQEQueryNode[] orgQRDs = querySet.getChildrenOfType(101055);
        ReportSpec reportSpec = this.retrieveReportSpec(modelPath, environment);
        this.addReportQueriesToQuerySet(querySet, reportSpec);
        this.updateQuerySet(querySet, reportSpec, environment);
        this.updateOriginalQueries(orgQueries);
        this.updateOriginalQRDs(orgQRDs);
        String expressionLocale = reportSpec.getExpressionLocale();
        if (Boolean.TRUE.equals(hHasMultiParts) && expressionLocale != null && (reportLC = FinalizeReportNode.getReportLocaleIfNeeded(expressionLocale, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale())) != null) {
            querySet.setPropertyValue("expressionLocale", expressionLocale);
            ((RequestEnvironment)environment.getRequestEnvironment()).setExpressionLocale(reportLC);
        }
    }

    private ReportSpec retrieveReportSpec(String modelPath, PlanningEnvironment environment) {
        ReportService rs = ((RequestEnvironment)environment.getRequestEnvironment()).getReportService();
        ReportServiceResponse resp = rs.getSpecification(modelPath, null);
        return new ReportSpec(resp, environment);
    }

    private void addReportQueriesToQuerySet(V5QuerySet querySet, ReportSpec reportSpec) {
        Boolean b = (Boolean)querySet.getPropertyValue(INJECT_FOR_REPORT);
        for (V5Query query : reportSpec.getQueries()) {
            if (Boolean.TRUE.equals(b)) {
                query.setPropertyValue(INJECT_FOR_REPORT, Boolean.TRUE);
            }
            querySet.addChild(query, querySet.getNumberChildren() - 1);
        }
    }

    private void updateQuerySet(V5QuerySet querySet, ReportSpec reportSpec, PlanningEnvironment environment) {
        Object requestEnv = environment.getRequestEnvironment();
        String modelPath = reportSpec.getModelPath();
        String modelType = reportSpec.getModelType();
        querySet.setStringPropertyValue("modelPath", modelPath);
        if (StringUtils.isNotEmpty((CharSequence)modelType)) {
            querySet.setStringPropertyValue("modelType", modelType);
        } else {
            querySet.removeProperty("modelType");
        }
        requestEnv.setModelPath(modelPath);
        requestEnv.setModelType(modelType);
        String name = reportSpec.getReportName();
        String storeId = reportSpec.getStoreId();
        String searchPath = reportSpec.getSearchPath();
        long lastModified = reportSpec.getLastModified();
        ReportSource reportSource = new ReportSource(name, storeId, searchPath, lastModified);
        querySet.addSource(reportSource);
    }

    private void updateOriginalQueries(IXQEQueryNode[] orgQueries) {
        for (IXQEQueryNode node : orgQueries) {
            V5Query v5Query = (V5Query)node;
            v5Query.setPropertyValue("name", this.renameReportQuery(v5Query.getV5QueryName()));
            V5Source source = (V5Source)v5Query.getFirstChildByType(101007);
            Set<String> referencedQueries = source.getReferencedQueries();
            if (CollectionUtils.isNotEmpty(referencedQueries)) {
                source.resetReferencedQueries();
                for (String referencedQuery : referencedQueries) {
                    source.addReferencedQuery(this.renameReportQuery(referencedQuery));
                }
                continue;
            }
            source.setModel(null);
            IXQEQueryNode[] expressions = node.getDescendantsOfType(101004, false);
            HashSet<String> queryRefs = new HashSet<String>();
            for (IXQEQueryNode e : expressions) {
                String[] ids;
                block8: {
                    V5MultiPartIdentifier multiPart;
                    String[] nameParts;
                    V5Expression expression = (V5Expression)e;
                    if (expression.getNumberChildren() == 0) {
                        try {
                            ids = UniqueNameParser.parse(expression.getExpression());
                            break block8;
                        }
                        catch (UniqueNameParserException e1) {
                            continue;
                        }
                    }
                    IXQEQueryNode[] multiParts = expression.getDescendantsOfType(201030, false);
                    if (multiParts.length != 1 || (nameParts = (multiPart = (V5MultiPartIdentifier)multiParts[0]).getNameParts()).length != 2) continue;
                    ids = nameParts;
                }
                queryRefs.add(ids[0]);
            }
            if (queryRefs.size() != 1) {
                throw new XQERuntimeException();
            }
            source.setQueryRef((String)queryRefs.iterator().next());
        }
    }

    private void updateOriginalQRDs(IXQEQueryNode[] orgQRDs) {
        for (IXQEQueryNode node : orgQRDs) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
            qrd.setRefQueryProperty(this.renameReportQuery(qrd.getRefQueryProperty()));
        }
    }

    private String renameReportQuery(String name) {
        return "foobar_" + name;
    }
}

