/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.v5.XV5Demo;
import com.cognos.xqe.trace.XQETrace;

public class InsertV5Demo
extends Transformation {
    private int gV5DemoDebug = 0;

    public InsertV5Demo() {
        this.mName = "Convert Sorted V5ValueSet To XCubeSort";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        XV5Demo v5Demo = (XV5Demo)nodeFactory.createXNode(501079);
        v5Demo.addV5DemoSpec(0, 1, 2);
        v5Demo.setDebug(this.gV5DemoDebug);
        IXQEQueryNode topNode = rsapiDataset.getChild(0);
        topNode.insertParent(v5Demo);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (this.gV5DemoDebug == 0) {
            this.traceQueryCondition(false, "gV5DemoDebug is 0.", trace);
            return false;
        }
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        if (rsapiDataset == null) {
            this.traceQueryCondition(false, "No RSAPIDATASET node is found.", trace);
            return false;
        }
        IXQEQueryNode[] cogMDXQueryNodes = rsapiDataset.getDescendantsOfType(501079, false);
        if (cogMDXQueryNodes.length != 0) {
            this.traceQueryCondition(false, "A V5Demo node is already inserted.", trace);
            return false;
        }
        this.traceNodeCondition(true, "A V5Demo node is created.", trace);
        return true;
    }
}

