/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.utils.V5NodeFormatResolver;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class PropagateDataItemCustomFormatProperty
extends Transformation {
    private static final int[] NODE_TYPES = new int[]{101003, 201085, 201031};

    public PropagateDataItemCustomFormatProperty() {
        this.mName = "Propagate format for projected DataItem in QRD";
        this.mPassNumbers = new int[]{5};
        this.mTypes = NODE_TYPES;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parentNode = node.getParent();
        String customFormat = (String)node.getPropertyValue("customFormat");
        parentNode.setPropertyValue("customFormat", customFormat);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parentNode;
        boolean status = false;
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "DataItem has invalid number of children.", trace);
            return status;
        }
        if (node.getPropertyValue("customFormat") != null && null != (parentNode = node.getParent()) && parentNode.isOfTypes(NODE_TYPES)) {
            String customFormat;
            if (parentNode.getPropertyValue("customFormat") == null) {
                this.traceNodeCondition(true, "Custom Format can be propagated.", trace);
                status = true;
            } else {
                this.traceNodeCondition(false, "DataItem ancestor already has a custom format.", trace);
                status = false;
            }
            if (201031 == parentNode.getNodeType() && null != (customFormat = (String)node.getPropertyValue("customFormat")) && !V5NodeFormatResolver.isPercentFormat(customFormat)) {
                this.traceNodeCondition(false, "Custom format does not need to be propagated.", trace);
                status = false;
            }
        }
        if (!status) {
            this.traceNodeCondition(false, "Custom Format cannot be propagated.", trace);
        }
        return status;
    }
}

