/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5IfExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.RefineCaseExpression;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class RefineIfThenElseExpression
extends Transformation {
    public static final String PROP_IFTHENELSE_COULD_BE_COLLAPSED = "isIfThenElseCouldBeCollapsed";
    public static final String PROP_COLLAPSED_IFTHENELSE_EXPRESSION = "isCollapsedIfThenElseExpr";

    public RefineIfThenElseExpression(int[] passNumbers) {
        this.mName = "Refine if-then-else expression";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201017};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        EvaluationTypeEnum evalType;
        IXQEQueryNode elseExpr;
        IXQEQueryNode booleanExpr = node.getChild(0);
        IXQEQueryNode thenExpr = node.getChild(1);
        if (RefineCaseExpression.isEqual(thenExpr, elseExpr = node.getChild(2))) {
            IXQEQueryNode[] prompts = booleanExpr.getDescendantsOfTypes(new int[]{201024, 201127}, false);
            StringBuilder sb = new StringBuilder();
            node.writeFormattedText(sb);
            if (prompts.length == 0) {
                thenExpr.setPropertyValue(PROP_IFTHENELSE_COULD_BE_COLLAPSED, true);
                thenExpr.setPropertyValue(PROP_COLLAPSED_IFTHENELSE_EXPRESSION, true);
                RefineCaseExpression.setQueryNotReusable(node);
                node.exchange(thenExpr, false);
                StringBuilder thenString = new StringBuilder();
                thenExpr.writeFormattedText(thenString);
                String nag = XQEMessages.getMessage(XQEMessageKeys.PLN_ExpressionIsCollapsedThenElseAreIdentical, XQEMessages.getCurrProductLocale(), sb.toString(), thenString.toString());
                ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nag);
                return;
            }
            String nag = XQEMessages.getMessage(XQEMessageKeys.PLN_ExpressionIsNotCollapsedBecauseOfPromptInCondition, XQEMessages.getCurrProductLocale(), sb.toString());
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nag);
        }
        if ((evalType = RefineIfThenElseExpression.evaluateBooleanExpression(booleanExpr, environment)) == EvaluationTypeEnum.UNKNOWN) {
            node.setPropertyValue(PROP_IFTHENELSE_COULD_BE_COLLAPSED, false);
            return;
        }
        if (evalType == EvaluationTypeEnum.MISSING_PARAMETER_VALUE) {
            node.setPropertyValue(PROP_IFTHENELSE_COULD_BE_COLLAPSED, true);
            return;
        }
        if (evalType == EvaluationTypeEnum.TRUE) {
            this.collapseToExpr(thenExpr, node, environment);
            return;
        }
        if (evalType == EvaluationTypeEnum.FALSE) {
            this.collapseToExpr(elseExpr, node, environment);
        }
    }

    protected void collapseToExpr(IXQEQueryNode expr, IXQEQueryNode node, PlanningEnvironment environment) {
        expr.setPropertyValue(PROP_COLLAPSED_IFTHENELSE_EXPRESSION, true);
        RefineCaseExpression.setQueryNotReusable(node);
        if (expr.getType() == 201023 && node.getParent().getType() != 201013) {
            IDataType dataType = ((V5IfExpression)node).getDataType();
            if (dataType != null && dataType.getCCLTypeCode() != 22) {
                if (!RQPUtilities.exprInOLAPContext(expr)) {
                    expr = RQPUtilities.buildCastNode(environment, expr, dataType);
                }
            } else {
                expr.setPropertyValue(PROP_COLLAPSED_IFTHENELSE_EXPRESSION, false);
                node.setPropertyValue(PROP_IFTHENELSE_COULD_BE_COLLAPSED, true);
                return;
            }
        }
        node.exchange(expr, false);
    }

    public static EvaluationTypeEnum evaluateBooleanExpression(IXQEQueryNode booleanExpr, PlanningEnvironment environment) {
        int type = booleanExpr.getType();
        if (type == 201003) {
            return RefineIfThenElseExpression.evaluateLogicalExpression(booleanExpr, environment);
        }
        return RefineIfThenElseExpression.evaluateComparisonExpression(booleanExpr, environment);
    }

    protected static EvaluationTypeEnum evaluateLogicalExpression(IXQEQueryNode logicalExpr, PlanningEnvironment environment) {
        V5LogicalExpression theV5LogicalExpression = (V5LogicalExpression)logicalExpr;
        int subType = theV5LogicalExpression.getSubType();
        if (subType == 2) {
            EvaluationTypeEnum evalType = RefineIfThenElseExpression.evaluateBooleanExpression(logicalExpr.getChild(0), environment);
            if (evalType == EvaluationTypeEnum.TRUE) {
                evalType = EvaluationTypeEnum.FALSE;
            } else if (evalType == EvaluationTypeEnum.FALSE) {
                evalType = EvaluationTypeEnum.TRUE;
            }
            return evalType;
        }
        EvaluationTypeEnum left = RefineIfThenElseExpression.evaluateBooleanExpression(logicalExpr.getChild(0), environment);
        EvaluationTypeEnum right = RefineIfThenElseExpression.evaluateBooleanExpression(logicalExpr.getChild(1), environment);
        if (subType == 0) {
            if (left == EvaluationTypeEnum.FALSE || right == EvaluationTypeEnum.FALSE) {
                return EvaluationTypeEnum.FALSE;
            }
            if (left == EvaluationTypeEnum.TRUE) {
                return right;
            }
            if (right == EvaluationTypeEnum.TRUE) {
                return left;
            }
            if (left == EvaluationTypeEnum.MISSING_PARAMETER_VALUE || right == EvaluationTypeEnum.MISSING_PARAMETER_VALUE) {
                return EvaluationTypeEnum.MISSING_PARAMETER_VALUE;
            }
            return EvaluationTypeEnum.UNKNOWN;
        }
        if (left == EvaluationTypeEnum.TRUE || right == EvaluationTypeEnum.TRUE) {
            return EvaluationTypeEnum.TRUE;
        }
        if (left == EvaluationTypeEnum.FALSE) {
            return right;
        }
        if (right == EvaluationTypeEnum.FALSE) {
            return left;
        }
        if (left == EvaluationTypeEnum.MISSING_PARAMETER_VALUE || right == EvaluationTypeEnum.MISSING_PARAMETER_VALUE) {
            return EvaluationTypeEnum.MISSING_PARAMETER_VALUE;
        }
        return EvaluationTypeEnum.UNKNOWN;
    }

    protected static EvaluationTypeEnum evaluateComparisonExpression(IXQEQueryNode comparisonNode, PlanningEnvironment environment) {
        if (!RefineIfThenElseExpression.isSupportedOperator(comparisonNode, null)) {
            return EvaluationTypeEnum.UNKNOWN;
        }
        int comparisonNodeType = comparisonNode.getType();
        IXQEQueryNode leftExpr = comparisonNode.getChild(0);
        if (comparisonNodeType == 201013 || comparisonNodeType == 201010) {
            IXQEQueryNode rightExpr = null;
            if (comparisonNodeType == 201013) {
                rightExpr = comparisonNode.getChild(1);
            }
            return RefineIfThenElseExpression.evaluateConditionClauseForCollapsing(leftExpr, rightExpr, environment);
        }
        if (comparisonNodeType == 201011) {
            IXQEQueryNode[] inChildren = comparisonNode.getChildren();
            IXQEQueryNode[] values = new IXQEQueryNode[inChildren.length - 1];
            System.arraycopy(inChildren, 1, values, 0, values.length);
            return RefineIfThenElseExpression.evaluateINExpression(leftExpr, values, environment);
        }
        return EvaluationTypeEnum.UNKNOWN;
    }

    protected static EvaluationTypeEnum evaluateINExpression(IXQEQueryNode leftExpr, IXQEQueryNode[] values, PlanningEnvironment environment) {
        EvaluationTypeEnum rt = null;
        if (values.length == 0) {
            return EvaluationTypeEnum.UNKNOWN;
        }
        for (IXQEQueryNode rightExpr : values) {
            EvaluationTypeEnum evalType = RefineIfThenElseExpression.evaluateConditionClauseForCollapsing(leftExpr, rightExpr, environment);
            if (evalType == EvaluationTypeEnum.TRUE) {
                return EvaluationTypeEnum.TRUE;
            }
            if (rt == null) {
                rt = evalType;
                continue;
            }
            if (evalType == EvaluationTypeEnum.MISSING_PARAMETER_VALUE) {
                rt = evalType;
                continue;
            }
            if (evalType != EvaluationTypeEnum.UNKNOWN || rt != EvaluationTypeEnum.FALSE) continue;
            rt = evalType;
        }
        return rt;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getPropertyValue(PROP_IFTHENELSE_COULD_BE_COLLAPSED) != null) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] children = ((V5IfExpression)node).getChildren();
        int three = 3;
        if (children.length != 3) {
            this.traceNodeCondition(false, "The V5IfExpression node does not have 3 children.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This IF expression can be refined.", trace);
        return true;
    }

    public static boolean isSupportedOperator(IXQEQueryNode firstChild, String[] reason) {
        if (RefineIfThenElseExpression.isSupportedComparisonOperator(firstChild, reason)) {
            return true;
        }
        int childType = firstChild.getType();
        if (childType == 201010) {
            if (reason != null) {
                reason[0] = "This IF expression contains an 'is Null' expression.";
            }
            return true;
        }
        if (childType == 201011) {
            if (reason != null) {
                reason[0] = "This IF expression contains an 'in' expression.";
            }
            return true;
        }
        return false;
    }

    public static boolean isSupportedComparisonOperator(IXQEQueryNode firstChild, String[] reason) {
        int comparisonType;
        int childType = firstChild.getType();
        if (childType == 201013 && ((comparisonType = ((V5ComparisonExpression)firstChild).getSubType()) == 2 || comparisonType == 3)) {
            if (reason != null) {
                reason[0] = "This IF expression contains a 'equals' or 'not equals' comparison expression.";
            }
            return true;
        }
        return false;
    }

    public static EvaluationTypeEnum evaluateConditionClauseForCollapsing(IXQEQueryNode leftExpr, IXQEQueryNode rightExpr, PlanningEnvironment environment) {
        if (!RefineIfThenElseExpression.canValueBeCompared(leftExpr) || rightExpr != null && !RefineIfThenElseExpression.canValueBeCompared(rightExpr)) {
            return EvaluationTypeEnum.UNKNOWN;
        }
        boolean leftValueIsNullLiteral = false;
        boolean rightValueIsNullLiteral = false;
        IXQEQueryNode parent = leftExpr.getParent();
        String leftValue = "";
        boolean isLeftValueAssigned = false;
        if (leftExpr.getType() == 201023) {
            leftValueIsNullLiteral = true;
        } else if (RefineIfThenElseExpression.isParameterNode(leftExpr)) {
            V5ParameterValueItem spvi = RefineIfThenElseExpression.getSingleParameterValueItem(leftExpr, environment);
            if (spvi == null) {
                leftValue = null;
            } else if (spvi.hasNullValue()) {
                leftValueIsNullLiteral = true;
            } else {
                leftValue = spvi.getInternalValue();
                isLeftValueAssigned = true;
            }
        } else {
            leftValue = RefineIfThenElseExpression.getExpressionStringValue(leftExpr);
            isLeftValueAssigned = true;
        }
        String rightValue = "";
        boolean isRightValueAssigned = false;
        if (rightExpr == null || rightExpr.getType() == 201023) {
            rightValueIsNullLiteral = true;
        } else if (RefineIfThenElseExpression.isParameterNode(rightExpr)) {
            V5ParameterValueItem spvi = RefineIfThenElseExpression.getSingleParameterValueItem(rightExpr, environment);
            if (spvi == null) {
                rightValue = null;
            } else if (spvi.hasNullValue()) {
                rightValueIsNullLiteral = true;
            } else {
                rightValue = spvi.getInternalValue();
                isRightValueAssigned = true;
            }
        } else {
            rightValue = RefineIfThenElseExpression.getExpressionStringValue(rightExpr);
            isRightValueAssigned = true;
        }
        if (leftExpr.getBooleanPropertyValue(PROP_IFTHENELSE_COULD_BE_COLLAPSED) == Boolean.FALSE || rightExpr != null && rightExpr.getBooleanPropertyValue(PROP_IFTHENELSE_COULD_BE_COLLAPSED) == Boolean.FALSE) {
            return EvaluationTypeEnum.UNKNOWN;
        }
        if (leftValue == null || rightValue == null) {
            return EvaluationTypeEnum.MISSING_PARAMETER_VALUE;
        }
        int parentType = parent.getType();
        int parentSubType = -1;
        if (parentType == 201013) {
            parentSubType = ((V5ComparisonExpression)parent).getSubType();
        }
        if (parentType == 201013 && parentSubType == 2 || parentType == 201011 || parentType == 201018 || parentType == 201019 || parentType == 201010) {
            if (leftValue.length() > 0 && rightValue.length() > 0 && leftValue.equals(rightValue)) {
                return EvaluationTypeEnum.TRUE;
            }
            if (isLeftValueAssigned && isRightValueAssigned) {
                if (leftValue.length() == 0 && rightValue.length() == 0) {
                    return EvaluationTypeEnum.TRUE;
                }
                if (leftValue.length() == 0 || rightValue.length() == 0) {
                    return EvaluationTypeEnum.FALSE;
                }
            }
            if (leftValueIsNullLiteral && rightValueIsNullLiteral) {
                return EvaluationTypeEnum.TRUE;
            }
            if (leftValueIsNullLiteral || rightValueIsNullLiteral) {
                return EvaluationTypeEnum.FALSE;
            }
        }
        if (parentType == 201013 && parentSubType == 3) {
            if (leftValue.length() > 0 && rightValue.length() > 0 && !leftValue.equals(rightValue)) {
                return EvaluationTypeEnum.TRUE;
            }
            if (isLeftValueAssigned && isRightValueAssigned) {
                if (leftValue.length() == 0 && rightValue.length() == 0) {
                    return EvaluationTypeEnum.FALSE;
                }
                if (leftValue.length() == 0 || rightValue.length() == 0) {
                    return EvaluationTypeEnum.TRUE;
                }
            }
            if (leftValueIsNullLiteral && rightValueIsNullLiteral) {
                return EvaluationTypeEnum.FALSE;
            }
            if (leftValueIsNullLiteral || rightValueIsNullLiteral) {
                return EvaluationTypeEnum.TRUE;
            }
        }
        return EvaluationTypeEnum.FALSE;
    }

    private static boolean canValueBeCompared(IXQEQueryNode expr) {
        if (expr.getType() == 201014 && ((V5ValueExpression)expr).getSubType() == 0) {
            for (IXQEQueryNode operand : expr.getChildren()) {
                if (RefineIfThenElseExpression.canValueBeCompared(operand)) continue;
                return false;
            }
            return true;
        }
        return expr.getType() == 201023 || expr.getType() == 201026 || expr.getType() == 201024 || expr.getType() == 201127;
    }

    public static String getExpressionStringValue(IXQEQueryNode expr) {
        String strValue = null;
        if (expr.getType() == 201026) {
            if (((V5LiteralValue)expr).getValue() != null) {
                strValue = ((V5LiteralValue)expr).getValue().toString();
            }
        } else if (expr.getType() == 201014 && ((V5ValueExpression)expr).getSubType() == 0) {
            StringBuilder sb = new StringBuilder();
            for (IXQEQueryNode operand : expr.getChildren()) {
                sb.append(RefineIfThenElseExpression.getExpressionStringValue(operand));
            }
            strValue = sb.toString();
        }
        return strValue;
    }

    public static boolean isParameterNode(IXQEQueryNode expr) {
        return expr.getType() == 201024 || expr.getType() == 201127;
    }

    public static V5ParameterValueItem getSingleParameterValueItem(IXQEQueryNode paramNode, PlanningEnvironment environment) {
        String promptName = paramNode.getType() == 201024 ? ((V5Parameter)paramNode).getParameterName() : ((V5BoundParameter)paramNode).getParameterName();
        Parameters params = ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters();
        Parameter param = params.getParameter(promptName);
        if (param != null) {
            param.bindToRequest((RequestEnvironment)environment.getRequestEnvironment());
            ParameterValues paramValues = param.getParameterValueItems();
            if (paramValues.size() == 1 && paramValues.get(0) instanceof V5ParameterValueItem) {
                return (V5ParameterValueItem)paramValues.get(0);
            }
            if (paramValues.size() > 1) {
                paramNode.setPropertyValue(PROP_IFTHENELSE_COULD_BE_COLLAPSED, false);
            }
        }
        return null;
    }

    public static enum EvaluationTypeEnum {
        UNKNOWN,
        TRUE,
        FALSE,
        MISSING_PARAMETER_VALUE;

    }
}

