/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;

public class RemoveDMRSlicerOnLevel
extends Transformation {
    public RemoveDMRSlicerOnLevel() {
        this.mName = "Remove level in slicer in a DMR query.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{101010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode child : children = node.getChildren()) {
            if (!this.useDirectlyALevel(child)) continue;
            child.detach();
        }
        if (node.getNumberChildren() == 0) {
            node.detach();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!DMRUtilities.findQuery(node).isDMR()) {
            this.traceNodeCondition(false, "Query is not DMR.", environment.getTrace());
            return false;
        }
        for (IXQEQueryNode child : node.getChildren()) {
            if (!this.useDirectlyALevel(child)) continue;
            this.traceNodeCondition(true, "V5Slicer in DMR query uses directly a level.", trace);
            return true;
        }
        this.traceNodeCondition(false, "V5Slicer in DMR query does not directly use a level.", trace);
        return false;
    }

    protected boolean useDirectlyALevel(IXQEQueryNode child) {
        int[] types = new int[]{101014, 101003, 201086};
        while (child.isOfTypes(types) && child.getNumberChildren() == 1) {
            child = child.getChild(0);
        }
        if (child.getType() != 201116) {
            return false;
        }
        V5BoundModelIdentifier id = (V5BoundModelIdentifier)child;
        IMetadata metadataObj = id.getMetadata();
        return metadataObj != null && metadataObj.getObjectType() == MetadataType.LEVEL;
    }
}

