/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;

public class RemoveOptionalFilterWithIgnoredParameter
extends Transformation {
    public RemoveOptionalFilterWithIgnoredParameter(int[] passNumbers) {
        this.mName = "Remove optional detail or summary filters that has unresolved prompt.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{101008, 101011, 801035};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        for (IXQEQueryNode boundParameter : node.getDescendantsOfType(201127, false)) {
            Parameter parameter = RemoveOptionalFilterWithIgnoredParameter.getParameter((V5BoundParameter)boundParameter, environment);
            if (parameter == null) continue;
            parameter.decrementQueryReferenceCount();
        }
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 801011 && parent.getChildren().length == 1) {
            parent.detach();
            return;
        }
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = false;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("dropFilterDueToPromptHandlingNoFault") != null) {
            return true;
        }
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        boolean isPromptHandlingNoFault = false;
        if (querySet != null && querySet.getIsPromptHandlingNoFault()) {
            isPromptHandlingNoFault = true;
        }
        IXQEQueryNode[] boundParameters = node.getDescendantsOfTypes(new int[]{201127, 201024}, false);
        if (!(node.getPropertyValue("dropFilterDueToNilMacroPromptValue") == null || isPromptHandlingNoFault && boundParameters.length <= 0)) {
            return true;
        }
        boolean isOptional = false;
        if (node.getType() == 101008) {
            if (((V5DetailFilter)node).getUseProperty().equals("optional")) {
                isOptional = true;
            }
        } else if (node.getType() == 101011) {
            if (((V5SummaryFilter)node).getUseProperty().equals("optional")) {
                isOptional = true;
            }
        } else if (node.getType() == 801035) {
            if (((RMEmbeddedFilter)node).getApply().equals("asNeeded")) {
                isOptional = true;
            }
            if (isPromptHandlingNoFault) {
                isOptional = true;
            }
        }
        if (!isOptional) {
            this.traceNodeCondition(status, "The filter is not optional.", trace);
            return status;
        }
        if (boundParameters.length == 0) {
            this.traceNodeCondition(status, "The filter does not contain prompt.", trace);
            return status;
        }
        if (isPromptHandlingNoFault) {
            this.traceNodeCondition(status, "Dropping filter because promptHandling is nofault and parameter values not resolved.", trace);
            return true;
        }
        for (int i = 0; i < boundParameters.length; ++i) {
            if (boundParameters[i].getType() == 201024) {
                this.traceNodeCondition(status, "V5Parameter node needs to be bound first.", trace);
                return status;
            }
            V5BoundParameter boundParameter = (V5BoundParameter)boundParameters[i];
            Parameter parameter = RemoveOptionalFilterWithIgnoredParameter.getParameter(boundParameter, environment);
            if (parameter == null || !parameter.isIgnored()) continue;
            if (RemoveOptionalFilterWithIgnoredParameter.resetParameter(boundParameter.getParent())) {
                parameter.getCapabilities().setOptional(false);
            }
            status = true;
        }
        this.traceNodeCondition(status, "The optional filter shold be removed because it has unresolved prompt.", trace);
        return status;
    }

    static final boolean resetParameter(IXQEQueryNode node) {
        V5DataItem dataItem = null;
        if (node == null || node.getType() == 101008 || node.getType() == 801035) {
            return false;
        }
        if (node.getType() != 101003) {
            return RemoveOptionalFilterWithIgnoredParameter.resetParameter(node.getParent());
        }
        dataItem = (V5DataItem)node;
        return dataItem.getIsProjected();
    }

    static final Parameter getParameter(V5BoundParameter boundParameter, PlanningEnvironment environment) {
        String parameterName = boundParameter.getParameterName();
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = requestEnv.getRequestParameters();
        return parameters.getParameter(parameterName);
    }
}

