/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class ReplaceDataItemRollupAggregateWithReferencedDataItemRollupAggregate
extends Transformation {
    public ReplaceDataItemRollupAggregateWithReferencedDataItemRollupAggregate() {
        this.mName = "Replace rollup aggregate with referenced data item rollup aggregate";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem v5DataItem = (V5DataItem)node;
        V5DataItem refDataItem = (V5DataItem)v5DataItem.getChild(0);
        String refRollupAggregate = refDataItem.getRollupAggregateProperty();
        v5DataItem.setRollupAggregateProperty(refRollupAggregate);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem v5DataItem = (V5DataItem)node;
        V5Query query = (V5Query)v5DataItem.getAncestorOfType(101006);
        if (query == null) {
            this.traceNodeCondition(false, "The node does not belong to an OLAP query", trace);
            return false;
        }
        if (!query.isTabular() && v5DataItem.getRollupAggregateProperty() != null) {
            V5RollupAggregateEnum rollupAggregate = V5RollupAggregateEnum.valueOfV5String(v5DataItem.getRollupAggregateProperty());
            if (rollupAggregate != V5RollupAggregateEnum.CALCULATED) {
                this.traceNodeCondition(false, "This 'rollupAggregate' property value is not calculated.", trace);
                return false;
            }
            IXQEQueryNode[] nodes = v5DataItem.getChildrenOfType(101003);
            if (nodes.length != 1) {
                this.traceNodeCondition(false, "This data item does not reference another data item.", trace);
                return false;
            }
            V5RollupAggregateEnum refRollupAggregate = V5RollupAggregateEnum.valueOfV5String(((V5DataItem)nodes[0]).getRollupAggregateProperty());
            if (refRollupAggregate == V5RollupAggregateEnum.UNKNOWN) {
                this.traceNodeCondition(false, "The referenced data item's rollup aggregate is invalid.", trace);
                return false;
            }
            if (refRollupAggregate == V5RollupAggregateEnum.CALCULATED) {
                this.traceNodeCondition(false, "The referenced data item's rollup aggregate is 'calculated'.", trace);
                return false;
            }
            this.traceQueryCondition(true, "The data item's rollup aggregate can be replaced with the referenced data item's rollup aggregate.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The node does not belong to an OLAP query.", trace);
        return false;
    }
}

