/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Slicer;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5InaccessibleMember;
import com.cognos.xqe.ast.v5Exp.V5LiteralRange;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.HierarchyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5tocogsql.optimization.JoinSummaryQueries;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Iterator;

public class ReplaceV5BoundParameterWithParameterValue
extends Transformation {
    private static final String REPLACE_DONE = "replaceV5BPWP_replDone";
    private static final String REPLACE_NOT_OPERATION_WAS_ADDED = "replaceV5BPWP_notWasAdded";
    private static boolean allowForInvert = true;

    public static boolean useNewWayForInvert() {
        return allowForInvert;
    }

    public ReplaceV5BoundParameterWithParameterValue() {
        this(new int[]{9});
    }

    public ReplaceV5BoundParameterWithParameterValue(int[] passNumbers) {
        this.mName = "Replace V5 bound parameter node with parameter value.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201127};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundParameter boundParameter = (V5BoundParameter)node;
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = requestEnv.getRequestParameters();
        String parameterName = boundParameter.getParameterName();
        Parameter parameter = parameters.getParameter(parameterName);
        parameter.setParameterValueRequiredBeforePlanning(true);
        parameter.setParameterReplacedByValue(true);
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (parameter.isMasterDetailLinkParameter()) {
            requestEnv.addQueryRequiresReplan((String)query.getPropertyValue("name"));
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode promptParentNode = boundParameter.getParent();
        if (parameter.isResolved()) {
            int countIncTrue = 0;
            int countIncFalse = 0;
            ParameterValues values = parameter.getParameterValueItems();
            for (ParameterValueItem vi : values) {
                if (vi.getBoundValue() == null) {
                    vi.bind(environment);
                }
                if (vi.getInclusive()) {
                    ++countIncTrue;
                    continue;
                }
                ++countIncFalse;
            }
            boolean processParmValues = true;
            boolean insertValuesForInAndInRangeClause = false;
            if (allowForInvert && countIncFalse > 0) {
                IXQEQueryNode[] parmNodes;
                if (promptParentNode.getType() != 201012 && promptParentNode.getType() != 201011 && !parameters.containsParameterWithNullValue()) {
                    processParmValues = false;
                }
                if (countIncTrue > 0) {
                    String context = this.expressionContext(promptParentNode);
                    throw new XQERuntimeException(XQEMessageKeys.PLN_MixedIncludeExcludeParameterValues, parameter.getName(), context);
                }
                if (promptParentNode.getType() != 201012 && promptParentNode.getType() != 201011) {
                    String context = this.expressionContext(promptParentNode);
                    throw new XQERuntimeException(XQEMessageKeys.PLN_InvertedParametersNotInBooleanContext, parameter.getName(), context);
                }
                if (promptParentNode.getType() == 201012 || promptParentNode.getType() == 201011) {
                    insertValuesForInAndInRangeClause = true;
                }
                if ((parmNodes = promptParentNode.getChildrenOfType(201127)).length > 1) {
                    String pname = parameter.getName();
                    String others = new String();
                    for (int i = 0; i < parmNodes.length; ++i) {
                        V5BoundParameter v5p = (V5BoundParameter)parmNodes[i];
                        String v5pname = v5p.getParameterName();
                        if (pname.equals(v5pname)) continue;
                        if (others.length() > 0) {
                            others = others + ", ";
                        }
                        others = others + v5pname;
                    }
                    if (promptParentNode.getType() == 201012 || promptParentNode.getType() == 201011) {
                        String context = this.expressionContext(promptParentNode);
                        throw new XQERuntimeException(XQEMessageKeys.PLN_MultipleInvertedParameters, (Object)pname, (Object)others, (Object)context);
                    }
                }
            }
            if (processParmValues) {
                int position = promptParentNode.getPositionOfChild(boundParameter);
                Iterator itValue = parameter.getParameterValueItems().iterator();
                while (itValue.hasNext()) {
                    IXQEQueryNode value = ((ParameterValueItem)itValue.next()).getBoundValue();
                    if (value == null) {
                        V5InaccessibleMember inaccessibleMember = (V5InaccessibleMember)nodeFactory.createNode(201139);
                        promptParentNode.addChild(inaccessibleMember, position);
                    } else {
                        IXQEQueryNode copy = nodeFactory.deepCopyNode(value);
                        if (allowForInvert) {
                            copy.setPropertyValue("inclusive", Boolean.TRUE);
                        }
                        promptParentNode.addChild(copy, position);
                    }
                    ++position;
                }
                promptParentNode.detachChild(boundParameter);
            }
            if (allowForInvert && countIncFalse > 0) {
                boolean addXisNull = true;
                if (addXisNull && promptParentNode.hasChildOfType(201023)) {
                    addXisNull = false;
                }
                if (addXisNull) {
                    V5SimpleNode sn;
                    IXQEQueryNode child0 = promptParentNode.getChild(0);
                    if (!JoinSummaryQueries.isNullable(child0)) {
                        addXisNull = false;
                    }
                    if (child0 instanceof V5SimpleNode && !(sn = (V5SimpleNode)child0).isNullable()) {
                        addXisNull = false;
                    }
                }
                if (insertValuesForInAndInRangeClause) {
                    IXQEQueryNode[] nullNodes = promptParentNode.getDescendantsOfType(201023, false);
                    for (int i = 0; i < nullNodes.length; ++i) {
                        nullNodes[i].extract();
                    }
                }
                if (promptParentNode.getPropertyValue(REPLACE_NOT_OPERATION_WAS_ADDED) == null) {
                    XQENodeFactory factory = environment.getNodeFactory();
                    V5LogicalExpression notExp = (V5LogicalExpression)factory.createNode(201003);
                    notExp.setSubType(2);
                    notExp.setPropertyValue(REPLACE_NOT_OPERATION_WAS_ADDED, Boolean.TRUE);
                    promptParentNode.insertParent(notExp);
                    if (addXisNull) {
                        IXQEQueryNode isNull = factory.createNode(201010);
                        isNull.setPropertyValue(REPLACE_NOT_OPERATION_WAS_ADDED, Boolean.TRUE);
                        isNull.addChild(factory.deepCopyNode(promptParentNode.getChild(0)));
                        V5LogicalExpression logicalOr = (V5LogicalExpression)factory.createNode(201003);
                        logicalOr.setSubType(1);
                        logicalOr.addChild(isNull);
                        notExp.insertParent(logicalOr);
                    }
                    promptParentNode.setPropertyValue(REPLACE_NOT_OPERATION_WAS_ADDED, Boolean.TRUE);
                }
                node.setPropertyValue(REPLACE_DONE, Boolean.TRUE);
            }
        } else {
            boolean parameterReplaced = this.replaceParameterWithDummyValue(parameter, boundParameter, environment, nodeFactory);
            if (!parameterReplaced) {
                throw new XQERuntimeException();
            }
        }
        IXQEQueryNode rootNode = environment.getRoot();
        if (rootNode.getType() == 101002) {
            ((V5QuerySet)rootNode).setNonReusable(true);
        }
    }

    private String expressionContext(IXQEQueryNode promptParentNode) {
        StringBuilder sb = new StringBuilder();
        promptParentNode.writeFormattedText(sb);
        String context = sb.toString();
        if (context == null || context.length() == 0) {
            context = promptParentNode.toString();
        }
        return context;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        int[] types;
        IXQEQueryNode slicerOrFilter;
        boolean status = false;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(REPLACE_DONE) != null) {
            return false;
        }
        V5BoundParameter prompt = (V5BoundParameter)node;
        if ("OUT".equalsIgnoreCase(prompt.getMode()) || "INOUT".equalsIgnoreCase(prompt.getMode()) || "IN".equalsIgnoreCase(prompt.getMode())) {
            return status;
        }
        if (!prompt.isMetadataAvailable()) {
            this.traceNodeCondition(status, "Metadata of V5BoundParameter node is not available.", trace);
            return status;
        }
        String parameterName = prompt.getParameterName();
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = requestEnv.getRequestParameters();
        Parameter parameter = parameters.getParameter(parameterName);
        if (parameter == null || parameter.isIgnored()) {
            this.traceNodeCondition(status, "The V5BoundParameter node is to be ignored.", trace);
            return status;
        }
        V5Query query = DMRUtilities.findQuery(node);
        boolean postAggrDF = false;
        if (query != null && query.isDMR() && !parameter.isMasterDetailLinkParameter() && (slicerOrFilter = node.getAncestorOfTypes(types = new int[]{101008, 101010})) != null) {
            if (slicerOrFilter.getType() == 101008) {
                postAggrDF = ((V5DetailFilter)slicerOrFilter).getPostAutoAggregation();
            }
            if (slicerOrFilter.getType() == 101010 || !postAggrDF) {
                status = true;
            }
        }
        StringBuilder msg = new StringBuilder();
        if (!status && allowForInvert && parameters.containsParameterWithInvertedValue()) {
            msg.append("The request does not have any inverted parameters.");
            status = true;
        }
        MultiRequestContext multiRequestContext = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext();
        if (!status && !prompt.isPromptValueRequiredBeforePlanning(msg, multiRequestContext, environment)) {
            this.traceNodeCondition(status, "No need to replace the prompt node with it's value. The prompt node can be converted to MDXParameterMember or MDXParameterValue.", trace);
            return false;
        }
        status = true;
        msg.append(" The prompt needs to be replaced with it's value.");
        this.traceNodeCondition(status, msg.toString(), trace);
        return status;
    }

    private boolean replaceParameterWithDummyValue(Parameter parameter, V5BoundParameter boundParameter, PlanningEnvironment environment, IXQENodeFactory nodeFactory) {
        V5DetailFilter detailFilter;
        boolean parameterReplaced = false;
        V5Slicer slicer = (V5Slicer)boundParameter.getAncestorOfType(101010);
        if (slicer != null) {
            slicer.getOriginalExpression();
        }
        if ((detailFilter = (V5DetailFilter)boundParameter.getAncestorOfType(101008)) != null) {
            detailFilter.getOriginalExpression();
        }
        if (boundParameter.isLiteral()) {
            V5LiteralValue dummyValue = this.createDummyValue(parameter, nodeFactory);
            if (dummyValue != null) {
                boolean isSecondChildOfV5InRange;
                boolean bl = isSecondChildOfV5InRange = boundParameter.getParent().getType() == 201012 && boundParameter.getParent().getPositionOfChild(boundParameter) == 1;
                if (isSecondChildOfV5InRange) {
                    V5LiteralRange newNode = (V5LiteralRange)nodeFactory.createNode(201022);
                    newNode.setSubType(2);
                    newNode.addChild(dummyValue);
                    newNode.addChild(nodeFactory.deepCopyNode(dummyValue));
                    boundParameter.exchange(newNode, false);
                    parameterReplaced = true;
                } else {
                    boundParameter.exchange(dummyValue, false);
                    parameterReplaced = true;
                }
            }
        } else if (boundParameter.isMultiMemberPrompt() || boundParameter.isMultiLevelPrompt(environment)) {
            IMetadata metadata = boundParameter.getMetadata();
            if (metadata.getDataType() == HierarchyType.HIERARCHYTYPE) {
                IHierarchy hierarchy = boundParameter.getHierarchy();
                V5SimpleNode newNode = (V5SimpleNode)nodeFactory.createNode(201061);
                V5BoundModelIdentifier hierarchyNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
                hierarchyNode.setMetadata(hierarchy);
                newNode.addChild(hierarchyNode);
                boundParameter.exchange(newNode, false);
                parameterReplaced = true;
            } else {
                V5SimpleNode item = (V5SimpleNode)nodeFactory.createNode(201076);
                V5SimpleNode members = (V5SimpleNode)nodeFactory.createNode(201086);
                V5BoundModelIdentifier modelBoundID = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
                modelBoundID.setMetadata(metadata);
                modelBoundID.setIdentifier(boundParameter.getIdentifier());
                V5LiteralValue value = (V5LiteralValue)nodeFactory.createNode(201026);
                value.setDataType(DataTypeFactory.getIntegerType());
                value.setValue(DataValueFactory.createIntegerValue(0));
                members.addChild(modelBoundID);
                item.addChild(members);
                item.addChild(value);
                boundParameter.exchange(item, false);
                parameterReplaced = true;
            }
        }
        return parameterReplaced;
    }

    private V5LiteralValue createDummyValue(Parameter parameter, IXQENodeFactory nodeFactory) {
        Value value = (Value)parameter.getDataType().createValue();
        IDataType dataType = parameter.getDataType(value.getV5formattedString());
        V5LiteralValue dummyValue = (V5LiteralValue)nodeFactory.createNode(201026);
        dummyValue.setDataType(dataType);
        dummyValue.setValue((Value)dataType.createValue());
        return dummyValue;
    }
}

