/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.cognos.xqemoser.ReportServiceResponse;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class ReportSpec {
    private static final String LAST_MODIFIED = "lastModified";
    private static final String MODEL_PATH = "modelPath";
    private static final String MODEL_TYPE = "modelType";
    private static final String QUERIES = "queries";
    private static final String REPORT_NAME = "reportName";
    private static final String RESP = "resp";
    private static final String SEARCH_PATH = "searchPath";
    private static final String STORE_ID = "storeId";
    private static final String V5_QUERIES = "v5Queries";
    private final ReportServiceResponse resp;
    private final PlanningEnvironment environment;
    private String modelPath;
    private String modelType;
    private String reportName;
    private long lastModified;
    private List<V5Query> v5Queries;
    private String expressionLocale;

    public ReportSpec(ReportServiceResponse resp, PlanningEnvironment environment) {
        this.resp = resp;
        this.environment = environment;
        boolean v5Format = this.environment.isReadV5SpecFormat();
        try {
            if (!v5Format) {
                this.environment.enableReadV5SpecFormat();
            }
            this.capture();
        }
        catch (Exception e) {
            throw new XQERuntimeException(e);
        }
        finally {
            if (!v5Format) {
                this.environment.disableReadV5SpecFormat();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void capture() throws Exception {
        this.lastModified = this.resp.getLastModified();
        String specification = this.resp.getSpecification();
        SAXReader xmlReader = null;
        try {
            xmlReader = XQESAXReaderPool.getInstance().borrowReader();
            Document document = xmlReader.read(new InputSource(new StringReader(specification)));
            Element root = document.getRootElement();
            if (root == null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidReportSpec);
            }
            this.captureRoot(root);
            if (CollectionUtils.isEmpty(this.v5Queries)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidReportSpec);
            }
        }
        finally {
            if (xmlReader != null) {
                XQESAXReaderPool.getInstance().returnReader(xmlReader);
            }
        }
    }

    private void captureRoot(Element ele) {
        Attribute lc = ele.attribute("expressionLocale");
        if (lc != null) {
            this.expressionLocale = lc.getValue();
        }
        List children = ele.elements();
        for (Element child : children) {
            String nodeName = child.getName();
            if (QUERIES.equals(nodeName)) {
                this.captureQueries(child);
                continue;
            }
            if (MODEL_PATH.equals(nodeName)) {
                this.captureModelPath(child);
                continue;
            }
            if (!REPORT_NAME.equals(nodeName)) continue;
            this.captureReportName(child);
        }
    }

    private void captureQueries(Element ele) {
        XQENodeFactory factory = this.environment.getNodeFactory();
        List children = ele.elements();
        for (Element query : children) {
            String nodeName = query.getName();
            V5QueryNode node = factory.createV5Node(nodeName);
            if (node == null || node.getType() != 101006) continue;
            node.capture(this.environment, query);
            this.addQuery((V5Query)node);
        }
    }

    private void addQuery(V5Query node) {
        if (this.v5Queries == null) {
            this.v5Queries = new ArrayList<V5Query>();
        }
        this.v5Queries.add(node);
    }

    private void captureModelPath(Element ele) {
        Attribute type = ele.attribute("type");
        if (type != null) {
            this.modelType = type.getValue();
        }
        this.modelPath = ele.getText();
    }

    private void captureReportName(Element ele) {
        this.reportName = ele.getText();
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getStoreId() {
        return this.resp.getStoreId();
    }

    public String getSearchPath() {
        return this.resp.getSearchPath();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public List<V5Query> getQueries() {
        return this.v5Queries;
    }

    public String getExpressionLocale() {
        return this.expressionLocale;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)LAST_MODIFIED, (Object)this.getLastModified());
        json.put((Object)MODEL_PATH, (Object)this.getModelPath());
        json.put((Object)MODEL_TYPE, (Object)this.getModelType());
        json.put((Object)REPORT_NAME, (Object)this.getReportName());
        json.put((Object)RESP, (Object)this.resp);
        json.put((Object)SEARCH_PATH, (Object)this.getSearchPath());
        json.put((Object)STORE_ID, (Object)this.getStoreId());
        json.put((Object)V5_QUERIES, (Object)this.dumpQueries());
        return json;
    }

    private JSONArray dumpQueries() {
        JSONArray result = new JSONArray();
        if (this.getQueries() != null) {
            for (V5Query query : this.getQueries()) {
                result.add((Object)query.dumpToString());
            }
        }
        return result;
    }
}

